/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.providers.NullPayload;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;
import org.mule.util.StringMessageUtils;

public abstract class AbstractTransformer
implements UMOTransformer {
    protected static final int DEFAULT_TRUNCATE_LENGTH = 200;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected Class returnClass = null;
    protected String name = null;
    protected UMOImmutableEndpoint endpoint = null;
    protected final List sourceTypes = new CopyOnWriteArrayList();
    protected UMOTransformer nextTransformer;
    private boolean ignoreBadInput = false;

    public AbstractTransformer() {
        this.name = this.generateTransformerName();
    }

    protected Object checkReturnClass(Object object) throws TransformerException {
        if (this.returnClass != null && !this.returnClass.isInstance(object)) {
            throw new TransformerException(new Message(53, object.getClass().getName(), (Object)this.returnClass.getName()), this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("The transformed object is of expected type. Type is: " + object.getClass().getName()));
        }
        return object;
    }

    protected void registerSourceType(Class aClass) {
        if (!this.sourceTypes.contains(aClass)) {
            this.sourceTypes.add(aClass);
            if (aClass.equals(Object.class)) {
                this.logger.debug((Object)"java.lang.Object has been added as source type for this transformer, there will be no source type checking performed");
            }
        }
    }

    protected void unregisterSourceType(Class aClass) {
        this.sourceTypes.remove(aClass);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string == null) {
            string = ClassUtils.getShortClassName(this.getClass());
        }
        this.logger.debug((Object)("Setting transformer name to: " + string));
        this.name = string;
    }

    public Class getReturnClass() {
        return this.returnClass;
    }

    public void setReturnClass(Class newClass) {
        this.returnClass = newClass;
    }

    public boolean isSourceTypeSupported(Class aClass) {
        return this.isSourceTypeSupported(aClass, false);
    }

    public boolean isSourceTypeSupported(Class aClass, boolean exactMatch) {
        int numTypes = this.sourceTypes.size();
        if (numTypes == 0) {
            return !exactMatch;
        }
        for (int i = 0; i < numTypes; ++i) {
            Class anotherClass = (Class)this.sourceTypes.get(i);
            if (!(exactMatch ? anotherClass.equals(aClass) : anotherClass.isAssignableFrom(aClass))) continue;
            return true;
        }
        return false;
    }

    public final Object transform(Object src) throws TransformerException {
        Object result;
        String encoding = null;
        if (src instanceof UMOMessage && !this.isSourceTypeSupported(UMOMessage.class)) {
            encoding = ((UMOMessage)src).getEncoding();
            src = ((UMOMessage)src).getPayload();
        }
        if (encoding == null && this.endpoint != null) {
            encoding = this.endpoint.getEncoding();
        }
        if (encoding == null) {
            encoding = MuleManager.getConfiguration().getEncoding();
        }
        if (!this.isSourceTypeSupported(src.getClass())) {
            if (this.ignoreBadInput) {
                this.logger.debug((Object)"Source type is incompatible with this transformer and property 'ignoreBadInput' is set to true, so the transformer chain will continue.");
                return src;
            }
            throw new TransformerException(new Message(54, this.getName(), (Object)src.getClass().getName(), this.endpoint != null ? this.endpoint.getEndpointURI() : null), this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Applying transformer " + this.getName() + " (" + this.getClass().getName() + ")"));
            this.logger.debug((Object)("Object before transform: " + StringMessageUtils.truncate(StringMessageUtils.toString(src), 200, false)));
        }
        if ((result = this.doTransform(src, encoding)) == null) {
            result = NullPayload.getInstance();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Object after transform: " + StringMessageUtils.truncate(StringMessageUtils.toString(result), 200, false)));
        }
        result = this.checkReturnClass(result);
        if (this.nextTransformer != null) {
            this.logger.debug((Object)("Following transformer in the chain is " + this.nextTransformer.getName() + " (" + this.nextTransformer.getClass().getName() + ")"));
            result = this.nextTransformer.transform(result);
        }
        return result;
    }

    public UMOImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(UMOImmutableEndpoint endpoint) {
        this.endpoint = endpoint;
        for (UMOTransformer trans = this.nextTransformer; trans != null && endpoint != null; trans = trans.getNextTransformer()) {
            trans.setEndpoint(endpoint);
        }
    }

    protected abstract Object doTransform(Object var1, String var2) throws TransformerException;

    public UMOTransformer getNextTransformer() {
        return this.nextTransformer;
    }

    public void setNextTransformer(UMOTransformer nextTransformer) {
        this.nextTransformer = nextTransformer;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            AbstractTransformer clone = (AbstractTransformer)BeanUtils.cloneBean((Object)this);
            clone.sourceTypes.clear();
            clone.sourceTypes.addAll(this.sourceTypes);
            if (this.nextTransformer != null) {
                clone.setNextTransformer((UMOTransformer)this.nextTransformer.clone());
            }
            clone.setEndpoint(this.endpoint);
            return clone;
        }
        catch (Exception e) {
            throw (CloneNotSupportedException)new CloneNotSupportedException("Failed to clone transformer: " + e.getMessage()).initCause(e);
        }
    }

    public Class getFinalReturnClass() {
        AbstractTransformer returnTrans = this;
        for (UMOTransformer tempTrans = this; tempTrans != null; tempTrans = tempTrans.getNextTransformer()) {
            returnTrans = tempTrans;
        }
        return returnTrans.getReturnClass();
    }

    public void initialise() throws InitialisationException {
    }

    protected String generateTransformerName() {
        return ClassUtils.getShortClassName(this.getClass());
    }

    public boolean isIgnoreBadInput() {
        return this.ignoreBadInput;
    }

    public void setIgnoreBadInput(boolean ignoreBadInput) {
        this.ignoreBadInput = ignoreBadInput;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        sb.append(ClassUtils.getShortClassName(this.getClass()));
        sb.append("{this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", ignoreBadInput=").append(this.ignoreBadInput);
        sb.append(", returnClass=").append(this.returnClass);
        sb.append(", sourceTypes=").append(this.sourceTypes);
        sb.append('}');
        return sb.toString();
    }

    public boolean isAcceptNull() {
        return false;
    }
}

