/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.mule.config.i18n.Message;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.routing.AbstractCatchAllStrategy;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.routing.ComponentRoutingException;
import org.mule.umo.routing.RoutingException;

public class ForwardingCatchAllStrategy
extends AbstractCatchAllStrategy {
    private boolean sendTransformed = false;

    public UMOMessage catchMessage(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        if (this.getEndpoint() == null) {
            throw new ComponentRoutingException(new Message(105), message, (UMOImmutableEndpoint)this.getEndpoint(), session.getComponent());
        }
        try {
            UMOEndpoint endpoint = this.getEndpoint();
            if (this.sendTransformed && endpoint.getTransformer() != null) {
                Object payload = message.getPayload();
                payload = endpoint.getTransformer().transform(payload);
                message = new MuleMessage(payload, message);
            }
            MuleEvent newEvent = new MuleEvent(message, (UMOImmutableEndpoint)endpoint, session, synchronous);
            if (synchronous) {
                UMOMessage result = endpoint.send(newEvent);
                if (this.statistics != null) {
                    this.statistics.incrementRoutedMessage(this.getEndpoint());
                }
                return result;
            }
            endpoint.dispatch(newEvent);
            if (this.statistics != null) {
                this.statistics.incrementRoutedMessage(this.getEndpoint());
            }
            return null;
        }
        catch (Exception e) {
            throw new RoutingException(message, this.getEndpoint(), (Throwable)e);
        }
    }

    public boolean isSendTransformed() {
        return this.sendTransformed;
    }

    public void setSendTransformed(boolean sendTransformed) {
        this.sendTransformed = sendTransformed;
    }
}

