/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractConnectionStrategy;
import org.mule.providers.FatalConnectException;
import org.mule.umo.provider.UMOConnectable;
import org.mule.util.ObjectUtils;

public class SimpleRetryConnectionStrategy
extends AbstractConnectionStrategy {
    public static final int DEFAULT_FREQUENCY = 2000;
    public static final int DEFAULT_RETRY_COUNT = 2;
    protected static final RetryCounter retryCounter = new RetryCounter();
    protected static final ThreadLocal called = new ThreadLocal();
    private volatile int retryCount = 2;
    private volatile long frequency = 2000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConnect(UMOConnectable connectable) throws FatalConnectException {
        while (true) {
            Boolean recursiveCallDetected;
            if (!(recursiveCallDetected = (Boolean)ObjectUtils.defaultIfNull(called.get(), (Object)Boolean.FALSE)).booleanValue()) {
                retryCounter.countRetry();
            }
            called.set(Boolean.TRUE);
            try {
                connectable.connect();
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug((Object)("Successfully connected to " + this.getDescription(connectable)));
            }
            catch (InterruptedException ie) {
                throw new FatalConnectException(new Message(164, this.getClass().getName(), (Object)this.getDescription(connectable)), ie, connectable);
            }
            catch (Exception e) {
                if (e instanceof FatalConnectException) {
                    throw (FatalConnectException)e;
                }
                if (retryCounter.current().get() >= this.retryCount) {
                    throw new FatalConnectException(new Message(164, this.getClass().getName(), (Object)this.getDescription(connectable)), e, connectable);
                }
                if (this.logger.isErrorEnabled()) {
                    StringBuffer msg = new StringBuffer(512);
                    msg.append("Failed to connect/reconnect: ").append(this.getDescription(connectable));
                    Throwable t = ExceptionHelper.getRootException(e);
                    msg.append(". Root Exception was: ").append(ExceptionHelper.writeException(t));
                    this.logger.error((Object)msg.toString(), (Throwable)e);
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Waiting for " + this.frequency + "ms before reconnecting. Failed attempt " + retryCounter.current().get() + " of " + this.retryCount));
                }
                try {
                    Thread.sleep(this.frequency);
                    continue;
                }
                catch (InterruptedException e1) {
                    throw new FatalConnectException(new Message(164, this.getClass().getName(), (Object)this.getDescription(connectable)), e, connectable);
                }
            }
            finally {
                called.set(Boolean.FALSE);
                continue;
            }
            break;
        }
    }

    public synchronized void resetState() {
        retryCounter.reset();
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long frequency) {
        this.frequency = frequency;
    }

    protected static class RetryCounter
    extends ThreadLocal {
        protected RetryCounter() {
        }

        public int countRetry() {
            return ((AtomicInteger)this.get()).incrementAndGet();
        }

        public void reset() {
            ((AtomicInteger)this.get()).set(0);
        }

        public AtomicInteger current() {
            return (AtomicInteger)this.get();
        }

        protected Object initialValue() {
            return new AtomicInteger(0);
        }
    }
}

