/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import java.beans.ExceptionListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkListener;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.MuleManager;
import org.mule.MuleRuntimeException;
import org.mule.config.ThreadingProfile;
import org.mule.config.i18n.Message;
import org.mule.impl.AlreadyInitialisedException;
import org.mule.impl.DefaultExceptionStrategy;
import org.mule.impl.ImmutableMuleEndpoint;
import org.mule.impl.MuleSessionHandler;
import org.mule.impl.internal.notifications.ConnectionNotification;
import org.mule.providers.ConnectException;
import org.mule.providers.ConnectionStrategy;
import org.mule.providers.DefaultReplyToHandler;
import org.mule.providers.FatalConnectException;
import org.mule.providers.KeyedPoolMessageDispatcherFactoryAdapter;
import org.mule.providers.ReplyToHandler;
import org.mule.providers.service.TransportFactory;
import org.mule.providers.service.TransportServiceDescriptor;
import org.mule.providers.service.TransportServiceException;
import org.mule.routing.filters.WildcardFilter;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.DisposeException;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.umo.provider.ConnectorException;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOConnectable;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.umo.provider.UMOMessageDispatcherFactory;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.umo.provider.UMOSessionHandler;
import org.mule.umo.provider.UMOStreamMessageAdapter;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.ClassUtils;
import org.mule.util.CollectionUtils;
import org.mule.util.ObjectNameHelper;
import org.mule.util.PropertiesUtils;
import org.mule.util.concurrent.NamedThreadFactory;
import org.mule.util.concurrent.WaitableBoolean;

public abstract class AbstractConnector
implements UMOConnector,
ExceptionListener,
UMOConnectable,
WorkListener {
    public static final int DEFAULT_NUM_CONCURRENT_TX_RECEIVERS = 4;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final AtomicBoolean started = new AtomicBoolean(false);
    protected final AtomicBoolean initialised = new AtomicBoolean(false);
    protected volatile String name;
    protected volatile ExceptionListener exceptionListener;
    protected final AtomicBoolean disposed = new AtomicBoolean(false);
    protected final AtomicBoolean disposing = new AtomicBoolean(false);
    protected volatile UMOMessageDispatcherFactory dispatcherFactory;
    protected final GenericKeyedObjectPool dispatchers = new GenericKeyedObjectPool();
    protected final ConcurrentMap receivers = new ConcurrentHashMap();
    private volatile ThreadingProfile dispatcherThreadingProfile = MuleManager.getConfiguration().getMessageDispatcherThreadingProfile();
    private volatile ThreadingProfile receiverThreadingProfile = MuleManager.getConfiguration().getMessageReceiverThreadingProfile();
    protected volatile boolean createMultipleTransactedReceivers = true;
    protected volatile int numberOfConcurrentTransactedReceivers = 4;
    protected volatile UMOTransformer defaultInboundTransformer;
    protected volatile UMOTransformer defaultOutboundTransformer;
    protected volatile UMOTransformer defaultResponseTransformer;
    protected volatile ConnectionStrategy connectionStrategy;
    protected final WaitableBoolean connected = new WaitableBoolean(false);
    protected final WaitableBoolean connecting = new WaitableBoolean(false);
    protected final WaitableBoolean startOnConnect = new WaitableBoolean(false);
    private volatile boolean enableMessageEvents;
    private final List supportedProtocols;
    private final AtomicReference receiverWorkManager = new AtomicReference();
    private final AtomicReference dispatcherWorkManager = new AtomicReference();
    private final AtomicReference scheduler = new AtomicReference();
    protected volatile TransportServiceDescriptor serviceDescriptor;
    protected volatile Properties serviceOverrides;
    protected volatile UMOSessionHandler sessionHandler = new MuleSessionHandler();

    public AbstractConnector() {
        this.exceptionListener = new DefaultExceptionStrategy();
        this.connectionStrategy = MuleManager.getConfiguration().getConnectionStrategy();
        this.enableMessageEvents = MuleManager.getConfiguration().isEnableMessageEvents();
        this.supportedProtocols = new ArrayList();
        this.supportedProtocols.add(this.getProtocol().toLowerCase());
        this.dispatchers.setTestOnBorrow(false);
        this.dispatchers.setTestOnReturn(true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(new Message(45, "Connector name").toString());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Set UMOConnector name to: " + newName));
        }
        this.name = newName;
    }

    public final synchronized void initialise() throws InitialisationException {
        if (this.initialised.get()) {
            throw new AlreadyInitialisedException("Connector '" + this.getName() + "'", (Object)this);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Initialising: " + this));
        }
        this.initFromServiceDescriptor();
        this.disposeDispatchers();
        this.disposeReceivers();
        this.doInitialise();
        if (this.exceptionListener instanceof Initialisable) {
            ((Initialisable)((Object)this.exceptionListener)).initialise();
        }
        this.initialised.set(true);
    }

    public final synchronized void startConnector() throws UMOException {
        this.checkDisposed();
        if (!this.isStarted()) {
            ScheduledExecutorService currentScheduler;
            if (!this.isConnected()) {
                this.startOnConnect.set(true);
                this.connectionStrategy.connect(this);
                return;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Starting: " + this));
            }
            if ((currentScheduler = (ScheduledExecutorService)this.scheduler.get()) == null || currentScheduler.isShutdown()) {
                this.scheduler.set((Object)this.getScheduler());
            }
            this.doStart();
            this.started.set(true);
            if (this.receivers != null) {
                Iterator iterator = this.receivers.values().iterator();
                while (iterator.hasNext()) {
                    UMOMessageReceiver mr = (UMOMessageReceiver)iterator.next();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Starting receiver on endpoint: " + mr.getEndpoint().getEndpointURI()));
                    }
                    mr.start();
                }
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Started: " + this));
            }
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public final synchronized void stopConnector() throws UMOException {
        if (this.isDisposed()) {
            return;
        }
        if (this.isStarted()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Stopping: " + this));
            }
            ((ScheduledExecutorService)this.scheduler.get()).shutdown();
            this.doStop();
            this.started.set(false);
            if (this.receivers != null) {
                Iterator iterator = this.receivers.values().iterator();
                while (iterator.hasNext()) {
                    UMOMessageReceiver mr = (UMOMessageReceiver)iterator.next();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Stopping receiver on endpoint: " + mr.getEndpoint().getEndpointURI()));
                    }
                    mr.stop();
                }
            }
        }
        if (this.isConnected()) {
            try {
                this.disconnect();
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to disconnect: " + e.getMessage()), (Throwable)e);
            }
        }
        this.scheduler.set(null);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Stopped: " + this));
        }
    }

    public final synchronized void dispose() {
        this.disposing.set(true);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Disposing: " + this));
        }
        try {
            this.stopConnector();
        }
        catch (UMOException e) {
            this.logger.warn((Object)("Failed to stop during shutdown: " + e.getMessage()), (Throwable)e);
        }
        this.disposeReceivers();
        this.disposeDispatchers();
        this.doDispose();
        this.disposed.set(true);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Disposed: " + this));
        }
    }

    protected void disposeReceivers() {
        if (this.receivers != null) {
            this.logger.debug((Object)"Disposing Receivers");
            Iterator iterator = this.receivers.values().iterator();
            while (iterator.hasNext()) {
                UMOMessageReceiver receiver = (UMOMessageReceiver)iterator.next();
                try {
                    this.destroyReceiver(receiver, receiver.getEndpoint());
                }
                catch (Throwable e) {
                    this.logger.error((Object)("Failed to destroy receiver: " + receiver), e);
                }
            }
            this.receivers.clear();
            this.logger.debug((Object)"Receivers Disposed");
        }
    }

    protected void disposeDispatchers() {
        if (this.dispatchers != null) {
            this.logger.debug((Object)"Disposing Dispatchers");
            try {
                if (this.isDisposing()) {
                    this.dispatchers.close();
                } else {
                    this.dispatchers.clear();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logger.debug((Object)"Dispatchers Disposed");
        }
    }

    public boolean isDisposed() {
        return this.disposed.get();
    }

    public void handleException(Exception exception) {
        if (this.exceptionListener == null) {
            throw new MuleRuntimeException(new Message(146, this.getName()), (Throwable)exception);
        }
        this.exceptionListener.exceptionThrown(exception);
    }

    public void exceptionThrown(Exception e) {
        this.handleException(e);
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) {
        this.exceptionListener = listener;
    }

    public UMOMessageDispatcherFactory getDispatcherFactory() {
        return this.dispatcherFactory;
    }

    public void setDispatcherFactory(UMOMessageDispatcherFactory dispatcherFactory) {
        Object poolFactory = dispatcherFactory instanceof KeyedPoolableObjectFactory ? (KeyedPoolableObjectFactory)dispatcherFactory : new KeyedPoolMessageDispatcherFactoryAdapter(dispatcherFactory);
        this.dispatchers.setFactory(poolFactory);
        this.dispatcherFactory = dispatcherFactory;
    }

    public int getMaxDispatchersActive() {
        return this.dispatchers.getMaxActive();
    }

    public void setMaxDispatchersActive(int maxActive) {
        this.dispatchers.setMaxActive(maxActive);
        this.dispatchers.setMaxIdle(maxActive);
    }

    private UMOMessageDispatcher getDispatcher(UMOImmutableEndpoint endpoint) throws UMOException {
        this.checkDisposed();
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint must not be null");
        }
        if (!this.supportsProtocol(endpoint.getConnector().getProtocol())) {
            throw new IllegalArgumentException(new Message(206, this.getProtocol(), (Object)endpoint.getEndpointURI().toString()).getMessage());
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Borrowing a dispatcher for endpoint: " + endpoint.getEndpointURI()));
            }
        }
        catch (Exception ex) {
            throw new ConnectorException(new Message(33), this, ex);
        }
        UMOMessageDispatcher dispatcher = null;
        try {
            UMOMessageDispatcher uMOMessageDispatcher = dispatcher = (UMOMessageDispatcher)this.dispatchers.borrowObject((Object)endpoint);
            return uMOMessageDispatcher;
        }
        catch (Exception ex) {
            throw new ConnectorException(new Message(33), this, ex);
        }
        finally {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Borrowed dispatcher: " + ObjectUtils.toString((Object)dispatcher, (String)"null")));
                }
            }
            catch (Exception ex) {
                throw new ConnectorException(new Message(33), this, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnDispatcher(UMOImmutableEndpoint endpoint, UMOMessageDispatcher dispatcher) {
        if (endpoint != null && dispatcher != null) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Returning dispatcher for endpoint: " + endpoint.getEndpointURI() + " = " + ObjectUtils.toString((Object)dispatcher, (String)"null")));
                }
            }
            catch (Exception ex) {
            }
            finally {
                try {
                    this.dispatchers.returnObject((Object)endpoint, (Object)dispatcher);
                }
                catch (Exception ex) {}
            }
        }
    }

    protected void checkDisposed() throws DisposeException {
        if (this.isDisposed()) {
            throw new DisposeException(new Message(32), (Object)this);
        }
    }

    public UMOMessageReceiver registerListener(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        if (endpoint == null) {
            throw new IllegalArgumentException("The endpoint cannot be null when registering a listener");
        }
        if (component == null) {
            throw new IllegalArgumentException("The component cannot be null when registering a listener");
        }
        UMOEndpointURI endpointUri = endpoint.getEndpointURI();
        if (endpointUri == null) {
            throw new ConnectorException(new Message(34), this);
        }
        this.logger.info((Object)("Registering listener: " + component.getDescriptor().getName() + " on endpointUri: " + endpointUri.toString()));
        UMOMessageReceiver receiver = this.getReceiver(component, endpoint);
        if (receiver != null) {
            throw new ConnectorException(new Message(35, endpointUri), this);
        }
        receiver = this.createReceiver(component, endpoint);
        Object receiverKey = this.getReceiverKey(component, endpoint);
        receiver.setReceiverKey(receiverKey.toString());
        this.receivers.put(receiverKey, (Object)receiver);
        return receiver;
    }

    protected Object getReceiverKey(UMOComponent component, UMOEndpoint endpoint) {
        return StringUtils.defaultIfEmpty((String)endpoint.getEndpointURI().getFilterAddress(), (String)endpoint.getEndpointURI().getAddress());
    }

    public final void unregisterListener(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        UMOMessageReceiver receiver;
        if (component == null) {
            throw new IllegalArgumentException("The component must not be null when you unregister a listener");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("The endpoint must not be null when you unregister a listener");
        }
        UMOEndpointURI endpointUri = endpoint.getEndpointURI();
        if (endpointUri == null) {
            throw new IllegalArgumentException("The endpointUri must not be null when you unregister a listener");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Removing listener on endpointUri: " + endpointUri));
        }
        if (this.receivers != null && !this.receivers.isEmpty() && (receiver = (UMOMessageReceiver)this.receivers.remove(this.getReceiverKey(component, endpoint))) != null) {
            this.destroyReceiver(receiver, endpoint);
        }
    }

    public ThreadingProfile getDispatcherThreadingProfile() {
        return this.dispatcherThreadingProfile;
    }

    public void setDispatcherThreadingProfile(ThreadingProfile dispatcherThreadingProfile) {
        this.dispatcherThreadingProfile = dispatcherThreadingProfile;
    }

    public ThreadingProfile getReceiverThreadingProfile() {
        return this.receiverThreadingProfile;
    }

    public void setReceiverThreadingProfile(ThreadingProfile receiverThreadingProfile) {
        this.receiverThreadingProfile = receiverThreadingProfile;
    }

    protected void destroyReceiver(UMOMessageReceiver receiver, UMOEndpoint endpoint) throws Exception {
        receiver.dispose();
    }

    protected abstract void doInitialise() throws InitialisationException;

    protected abstract void doDispose();

    protected abstract void doStart() throws UMOException;

    protected abstract void doStop() throws UMOException;

    public UMOTransformer getDefaultInboundTransformer() {
        if (this.defaultInboundTransformer != null) {
            try {
                return (UMOTransformer)this.defaultInboundTransformer.clone();
            }
            catch (CloneNotSupportedException e) {
                this.logger.error((Object)"Failed to clone default Inbound transformer");
            }
        }
        return null;
    }

    public void setDefaultInboundTransformer(UMOTransformer defaultInboundTransformer) {
        this.defaultInboundTransformer = defaultInboundTransformer;
    }

    public UMOTransformer getDefaultResponseTransformer() {
        if (this.defaultResponseTransformer != null) {
            try {
                return (UMOTransformer)this.defaultResponseTransformer.clone();
            }
            catch (CloneNotSupportedException e) {
                this.logger.error((Object)"Failed to clone default Outbound transformer");
            }
        }
        return null;
    }

    public UMOTransformer getDefaultOutboundTransformer() {
        if (this.defaultOutboundTransformer != null) {
            try {
                return (UMOTransformer)this.defaultOutboundTransformer.clone();
            }
            catch (CloneNotSupportedException e) {
                this.logger.error((Object)"Failed to clone default Outbound transformer");
            }
        }
        return null;
    }

    public void setDefaultOutboundTransformer(UMOTransformer defaultOutboundTransformer) {
        this.defaultOutboundTransformer = defaultOutboundTransformer;
    }

    public void setDefaultResponseTransformer(UMOTransformer defaultResponseTransformer) {
        this.defaultResponseTransformer = defaultResponseTransformer;
    }

    public ReplyToHandler getReplyToHandler() {
        return new DefaultReplyToHandler(this.defaultResponseTransformer);
    }

    public void fireNotification(UMOServerNotification notification) {
        MuleManager.getInstance().fireNotification(notification);
    }

    public ConnectionStrategy getConnectionStrategy() {
        try {
            return (ConnectionStrategy)BeanUtils.cloneBean((Object)this.connectionStrategy);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(new Message(145, "connectionStrategy"), (Throwable)e);
        }
    }

    public void setConnectionStrategy(ConnectionStrategy connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
    }

    public boolean isDisposing() {
        return this.disposing.get();
    }

    public boolean isRemoteSyncEnabled() {
        return false;
    }

    public UMOMessageReceiver getReceiver(UMOComponent component, UMOEndpoint endpoint) {
        return (UMOMessageReceiver)this.receivers.get(this.getReceiverKey(component, endpoint));
    }

    public Map getReceivers() {
        return Collections.unmodifiableMap(this.receivers);
    }

    public UMOMessageReceiver lookupReceiver(String key) {
        if (key != null) {
            return (UMOMessageReceiver)this.receivers.get((Object)key);
        }
        throw new IllegalArgumentException("Receiver key must not be null");
    }

    public UMOMessageReceiver[] getReceivers(String wildcardExpression) {
        WildcardFilter filter = new WildcardFilter(wildcardExpression);
        filter.setCaseSensitive(false);
        ArrayList found = new ArrayList();
        Iterator iterator = this.receivers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e = (Map.Entry)iterator.next();
            if (!filter.accept(e.getKey())) continue;
            found.add(e.getValue());
        }
        return (UMOMessageReceiver[])CollectionUtils.toArrayOfComponentType(found, UMOMessageReceiver.class);
    }

    public void connect() throws Exception {
        this.checkDisposed();
        if (this.connected.get()) {
            return;
        }
        try {
            if (this.connecting.get()) {
                this.doConnect();
            }
            if (this.connecting.compareAndSet(false, true)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Connecting: " + this));
                }
                this.connectionStrategy.connect(this);
                this.logger.info((Object)("Connected: " + this.getConnectionDescription()));
                return;
            }
            this.connected.set(true);
            this.connecting.set(false);
            this.fireNotification(new ConnectionNotification(this, this.getConnectEventId(), 701));
        }
        catch (Exception e) {
            this.connected.set(false);
            this.connecting.set(false);
            this.fireNotification(new ConnectionNotification(this, this.getConnectEventId(), 702));
            if (e instanceof ConnectException || e instanceof FatalConnectException) {
                throw e;
            }
            throw new ConnectException(e, (Object)this);
        }
        if (this.startOnConnect.get()) {
            this.startConnector();
        } else {
            Iterator iterator = this.receivers.values().iterator();
            while (iterator.hasNext()) {
                UMOMessageReceiver receiver = (UMOMessageReceiver)iterator.next();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Connecting receiver on endpoint: " + receiver.getEndpoint().getEndpointURI()));
                }
                receiver.connect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws Exception {
        this.startOnConnect.set(this.isStarted());
        this.fireNotification(new ConnectionNotification(this, this.getConnectEventId(), 703));
        this.connected.set(false);
        try {
            this.doDisconnect();
        }
        finally {
            this.stopConnector();
        }
        this.logger.info((Object)("Disconnected: " + this.getConnectionDescription()));
    }

    public String getConnectionDescription() {
        return this.toString();
    }

    public final boolean isConnected() {
        return this.connected.get();
    }

    protected abstract void doConnect() throws Exception;

    protected abstract void doDisconnect() throws Exception;

    protected String getConnectEventId() {
        return this.getName();
    }

    public boolean isCreateMultipleTransactedReceivers() {
        return this.createMultipleTransactedReceivers;
    }

    public void setCreateMultipleTransactedReceivers(boolean createMultipleTransactedReceivers) {
        this.createMultipleTransactedReceivers = createMultipleTransactedReceivers;
    }

    public int getNumberOfConcurrentTransactedReceivers() {
        return this.numberOfConcurrentTransactedReceivers;
    }

    public void setNumberOfConcurrentTransactedReceivers(int count) {
        this.numberOfConcurrentTransactedReceivers = count;
    }

    public boolean isEnableMessageEvents() {
        return this.enableMessageEvents;
    }

    public void setEnableMessageEvents(boolean enableMessageEvents) {
        this.enableMessageEvents = enableMessageEvents;
    }

    public void registerSupportedProtocol(String protocol) {
        if ((protocol = protocol.toLowerCase()).startsWith(this.getProtocol().toLowerCase())) {
            this.registerSupportedProtocolWithoutPrefix(protocol);
        } else {
            this.supportedProtocols.add(this.getProtocol().toLowerCase() + ":" + protocol);
        }
    }

    protected void registerSupportedProtocolWithoutPrefix(String protocol) {
        this.supportedProtocols.add(protocol.toLowerCase());
    }

    public void unregisterSupportedProtocol(String protocol) {
        if ((protocol = protocol.toLowerCase()).startsWith(this.getProtocol().toLowerCase())) {
            this.supportedProtocols.remove(protocol);
        } else {
            this.supportedProtocols.remove(this.getProtocol().toLowerCase() + ":" + protocol);
        }
    }

    public boolean supportsProtocol(String protocol) {
        return this.supportedProtocols.contains(protocol.toLowerCase());
    }

    public List getSupportedProtocols() {
        return Collections.unmodifiableList(this.supportedProtocols);
    }

    public void setSupportedProtocols(List supportedProtocols) {
        Iterator iterator = supportedProtocols.iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            this.registerSupportedProtocol(s);
        }
    }

    protected UMOWorkManager getReceiverWorkManager(String receiverName) throws UMOException {
        UMOWorkManager newWorkManager;
        if (this.receiverWorkManager.get() == null && this.receiverWorkManager.compareAndSet(null, (Object)(newWorkManager = this.getReceiverThreadingProfile().createWorkManager(this.getName() + '.' + receiverName)))) {
            newWorkManager.start();
        }
        return (UMOWorkManager)this.receiverWorkManager.get();
    }

    protected UMOWorkManager getDispatcherWorkManager() throws UMOException {
        UMOWorkManager newWorkManager;
        if (this.dispatcherWorkManager.get() == null && this.dispatcherWorkManager.compareAndSet(null, (Object)(newWorkManager = this.getDispatcherThreadingProfile().createWorkManager(this.getName() + ".dispatcher")))) {
            newWorkManager.start();
        }
        return (UMOWorkManager)this.dispatcherWorkManager.get();
    }

    public ScheduledExecutorService getScheduler() {
        if (this.scheduler.get() == null) {
            NamedThreadFactory threadFactory = new NamedThreadFactory(this.getName() + ".scheduler");
            ScheduledThreadPoolExecutor newExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)threadFactory);
            newExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            newExecutor.setKeepAliveTime(this.getReceiverThreadingProfile().getThreadTTL(), TimeUnit.MILLISECONDS);
            if (!this.scheduler.compareAndSet(null, (Object)newExecutor)) {
                newExecutor.shutdown();
            }
        }
        return (ScheduledExecutorService)this.scheduler.get();
    }

    public UMOSessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    public void setSessionHandler(UMOSessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    public void workAccepted(WorkEvent event) {
        this.handleWorkException(event, "workAccepted");
    }

    public void workRejected(WorkEvent event) {
        this.handleWorkException(event, "workRejected");
    }

    public void workStarted(WorkEvent event) {
        this.handleWorkException(event, "workStarted");
    }

    public void workCompleted(WorkEvent event) {
        this.handleWorkException(event, "workCompleted");
    }

    protected void handleWorkException(WorkEvent event, String type) {
        if (event == null) {
            return;
        }
        Throwable e = event.getException();
        if (e == null) {
            return;
        }
        if (e.getCause() != null) {
            e = e.getCause();
        }
        this.logger.error((Object)("Work caused exception on '" + type + "'. Work being executed was: " + event.getWork().toString()));
        if (!(e instanceof Exception)) {
            throw new MuleRuntimeException(new Message(33, this.getName()), e);
        }
        this.handleException((Exception)e);
    }

    public void dispatch(UMOImmutableEndpoint endpoint, UMOEvent event) throws DispatchException {
        UMOMessageDispatcher dispatcher = null;
        try {
            dispatcher = this.getDispatcher(endpoint);
            dispatcher.dispatch(event);
        }
        catch (DispatchException dex) {
            throw dex;
        }
        catch (UMOException ex) {
            throw new DispatchException(event.getMessage(), endpoint, (Throwable)ex);
        }
        finally {
            this.returnDispatcher(endpoint, dispatcher);
        }
    }

    public UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        return this.receive(new ImmutableMuleEndpoint(endpointUri.toString(), true), timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UMOMessage receive(UMOImmutableEndpoint endpoint, long timeout) throws Exception {
        UMOMessageDispatcher dispatcher = null;
        try {
            dispatcher = this.getDispatcher(endpoint);
            UMOMessage uMOMessage = dispatcher.receive(timeout);
            return uMOMessage;
        }
        finally {
            this.returnDispatcher(endpoint, dispatcher);
        }
    }

    public UMOMessage send(UMOImmutableEndpoint endpoint, UMOEvent event) throws DispatchException {
        UMOMessageDispatcher dispatcher = null;
        try {
            dispatcher = this.getDispatcher(endpoint);
            UMOMessage uMOMessage = dispatcher.send(event);
            return uMOMessage;
        }
        catch (DispatchException dex) {
            throw dex;
        }
        catch (UMOException ex) {
            throw new DispatchException(event.getMessage(), endpoint, (Throwable)ex);
        }
        finally {
            this.returnDispatcher(endpoint, dispatcher);
        }
    }

    public void initialiseFromUrl(UMOEndpointURI endpointUri) throws InitialisationException {
        String host;
        if (!this.supportsProtocol(endpointUri.getFullScheme())) {
            throw new InitialisationException(new Message(115, endpointUri.getFullScheme(), (Object)this.getClass().getName()), (Object)this);
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)endpointUri.getParams());
        if (endpointUri.getUserInfo() != null) {
            props.setProperty("username", endpointUri.getUsername());
            String passwd = endpointUri.getPassword();
            if (passwd != null) {
                props.setProperty("password", passwd);
            }
        }
        if ((host = endpointUri.getHost()) != null) {
            props.setProperty("hostname", host);
            props.setProperty("host", host);
        }
        if (endpointUri.getPort() > -1) {
            props.setProperty("port", String.valueOf(endpointUri.getPort()));
        }
        org.mule.util.BeanUtils.populateWithoutFail(this, props, true);
        this.setName(ObjectNameHelper.getConnectorName(this));
    }

    protected synchronized void initFromServiceDescriptor() throws InitialisationException {
        try {
            this.serviceDescriptor = TransportFactory.getServiceDescriptor(this.getProtocol().toLowerCase(), this.serviceOverrides);
            if (this.serviceDescriptor.getDispatcherFactory() != null) {
                this.logger.debug((Object)("Loading DispatcherFactory: " + this.serviceDescriptor.getDispatcherFactory()));
                this.setDispatcherFactory(this.serviceDescriptor.createDispatcherFactory());
            }
            this.defaultInboundTransformer = this.serviceDescriptor.createInboundTransformer();
            this.defaultOutboundTransformer = this.serviceDescriptor.createOutboundTransformer();
            this.defaultResponseTransformer = this.serviceDescriptor.createResponseTransformer();
            this.sessionHandler = this.serviceDescriptor.createSessionHandler();
            Map props = new HashMap();
            PropertiesUtils.getPropertiesWithPrefix(MuleManager.getInstance().getProperties(), this.getProtocol().toLowerCase(), props);
            if (props.size() > 0) {
                props = PropertiesUtils.removeNamespaces(props);
                org.mule.util.BeanUtils.populateWithoutFail(this, props, true);
            }
        }
        catch (Exception e) {
            throw new InitialisationException(e, (Object)this);
        }
    }

    protected TransportServiceDescriptor getServiceDescriptor() {
        if (this.serviceDescriptor == null) {
            throw new IllegalStateException("This connector has not yet been initialised: " + this.name);
        }
        return this.serviceDescriptor;
    }

    protected UMOMessageReceiver createReceiver(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        return this.getServiceDescriptor().createMessageReceiver(this, component, endpoint);
    }

    public UMOMessageAdapter getMessageAdapter(Object message) throws MessagingException {
        try {
            return this.serviceDescriptor.createMessageAdapter(message);
        }
        catch (TransportServiceException e) {
            throw new MessagingException(new Message(65, "Message Adapter"), message, (Throwable)e);
        }
    }

    public UMOStreamMessageAdapter getStreamMessageAdapter(InputStream in, OutputStream out) throws MessagingException {
        try {
            return this.serviceDescriptor.createStreamMessageAdapter(in, out);
        }
        catch (TransportServiceException e) {
            throw new MessagingException(new Message(65, "Stream Message Adapter"), in, (Throwable)e);
        }
    }

    public Map getServiceOverrides() {
        return this.serviceOverrides;
    }

    public void setServiceOverrides(Map serviceOverrides) {
        this.serviceOverrides = new Properties();
        this.serviceOverrides.putAll((Map<?, ?>)serviceOverrides);
    }

    public OutputStream getOutputStream(UMOImmutableEndpoint endpoint, UMOMessage message) throws UMOException {
        throw new UnsupportedOperationException(new Message(209, this.getProtocol()).toString());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(120);
        sb.append(ClassUtils.getShortClassName(this.getClass()));
        sb.append("{this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", started=").append(this.started);
        sb.append(", initialised=").append(this.initialised);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", disposed=").append(this.disposed);
        sb.append(", numberOfConcurrentTransactedReceivers=").append(this.numberOfConcurrentTransactedReceivers);
        sb.append(", createMultipleTransactedReceivers=").append(this.createMultipleTransactedReceivers);
        sb.append(", connected=").append(this.connected);
        sb.append(", supportedProtocols=").append(this.supportedProtocols);
        sb.append(", serviceOverrides=").append(this.serviceOverrides);
        sb.append('}');
        return sb.toString();
    }
}

