/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.counters.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mule.util.counters.Counter;
import org.mule.util.counters.CounterFactory;
import org.mule.util.counters.impl.AbstractCounter;
import org.mule.util.counters.impl.Average;
import org.mule.util.counters.impl.Delta;
import org.mule.util.counters.impl.InstantRate;
import org.mule.util.counters.impl.Max;
import org.mule.util.counters.impl.Min;
import org.mule.util.counters.impl.Number;
import org.mule.util.counters.impl.Operator;
import org.mule.util.counters.impl.RatePerUnit;
import org.mule.util.counters.impl.Sum;
import org.mule.util.counters.impl.TimeAverage;

public final class CounterFactoryImpl {
    private static Map counters = new HashMap();
    private static ArrayList publicCounters = new ArrayList();

    private CounterFactoryImpl() {
    }

    public static Counter getCounter(String name) {
        return (Counter)counters.get(name);
    }

    public static Counter createCounter(String name, String first, String second, CounterFactory.Type type, boolean visible) {
        Counter counter = CounterFactoryImpl.getCounter(name);
        if (counter != null) {
            throw new IllegalStateException();
        }
        counter = CounterFactoryImpl.internalCreateCounter(name, first, second, type, visible);
        return counter;
    }

    public static Iterator getCounters() {
        return publicCounters.iterator();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static AbstractCounter internalCreateCounter(String name, String first, String second, CounterFactory.Type type, boolean visible) {
        void var5_19;
        Object var5_5 = null;
        if (name == null) {
            throw new IllegalStateException();
        }
        if (first == null && second == null) {
            if (type != CounterFactory.Type.NUMBER) throw new IllegalStateException();
            Number number = new Number(name);
        } else if (first != null && second == null) {
            AbstractCounter b = (AbstractCounter)CounterFactoryImpl.getCounter(first);
            if (b == null) {
                throw new IllegalStateException();
            }
            if (type == CounterFactory.Type.MIN) {
                Min min = new Min(name, b);
            } else if (type == CounterFactory.Type.MAX) {
                Max max = new Max(name, b);
            } else if (type == CounterFactory.Type.SUM) {
                Sum sum = new Sum(name, b);
            } else if (type == CounterFactory.Type.AVERAGE) {
                Average average = new Average(name, b);
            } else if (type == CounterFactory.Type.TIME_AVERAGE) {
                TimeAverage timeAverage = new TimeAverage(name, b);
            } else if (type == CounterFactory.Type.DELTA) {
                Delta delta = new Delta(name, b);
            } else if (type == CounterFactory.Type.INSTANT_RATE) {
                InstantRate instantRate = new InstantRate(name, b);
            } else {
                if (type != CounterFactory.Type.RATE_PER_SECOND && type != CounterFactory.Type.RATE_PER_MINUTE && type != CounterFactory.Type.RATE_PER_HOUR) throw new IllegalStateException();
                RatePerUnit ratePerUnit = new RatePerUnit(name, null, type, b);
            }
        } else {
            if (first == null || second == null) throw new IllegalStateException();
            AbstractCounter b = (AbstractCounter)CounterFactoryImpl.getCounter(first);
            if (b == null) {
                throw new IllegalStateException();
            }
            if (type == CounterFactory.Type.RATE_PER_SECOND || type == CounterFactory.Type.RATE_PER_MINUTE || type == CounterFactory.Type.RATE_PER_HOUR) {
                RatePerUnit ratePerUnit = new RatePerUnit(name, second, type, b);
            } else {
                if (type != CounterFactory.Type.PLUS && type != CounterFactory.Type.MINUS && type != CounterFactory.Type.MULTIPLY && type != CounterFactory.Type.DIVIDE) throw new IllegalStateException();
                AbstractCounter b2 = (AbstractCounter)CounterFactoryImpl.getCounter(second);
                if (b2 == null) {
                    throw new IllegalStateException();
                }
                Operator operator = new Operator(name, b, b2, type);
            }
        }
        counters.put(name, var5_19);
        if (!visible) return var5_19;
        publicCounters.add(var5_19);
        return var5_19;
    }
}

