/*
 * Decompiled with CFR 0.152.
 */
package org.mule.umo.security.tls;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.security.TlsDirectKeyStore;
import org.mule.umo.security.TlsDirectTrustStore;
import org.mule.umo.security.TlsIndirectKeyStore;
import org.mule.umo.security.provider.AutoDiscoverySecurityProviderFactory;
import org.mule.umo.security.provider.SecurityProviderFactory;
import org.mule.umo.security.provider.SecurityProviderInfo;
import org.mule.umo.security.tls.TlsPropertiesMapper;
import org.mule.util.FileUtils;
import org.mule.util.IOUtils;

public final class TlsConfiguration
implements TlsDirectTrustStore,
TlsDirectKeyStore,
TlsIndirectKeyStore {
    public static final String DEFAULT_KEYSTORE = ".keystore";
    public static final String DEFAULT_KEYSTORE_TYPE = KeyStore.getDefaultType();
    public static final String DEFAULT_SSL_TYPE = "SSLv3";
    public static final String JSSE_NAMESPACE = "javax.net";
    private Log logger = LogFactory.getLog(this.getClass());
    private SecurityProviderFactory spFactory = new AutoDiscoverySecurityProviderFactory();
    private SecurityProviderInfo spInfo = this.spFactory.getSecurityProviderInfo();
    private Provider provider = this.spFactory.getProvider();
    private String sslType = "SSLv3";
    private String protocolHandler = this.spInfo.getProtocolHandler();
    private String keyStoreName = ".keystore";
    private String keyPassword = null;
    private String keyStorePassword = null;
    private String keystoreType = DEFAULT_KEYSTORE_TYPE;
    private String keyManagerAlgorithm = this.spInfo.getKeyManagerAlgorithm();
    private KeyManagerFactory keyManagerFactory = null;
    private String clientKeyStoreName = null;
    private String clientKeyStorePassword = null;
    private String clientKeyStoreType = DEFAULT_KEYSTORE_TYPE;
    private String trustStoreName = null;
    private String trustStorePassword = null;
    private String trustStoreType = DEFAULT_KEYSTORE_TYPE;
    private String trustManagerAlgorithm = this.spInfo.getKeyManagerAlgorithm();
    private TrustManagerFactory trustManagerFactory = null;
    private boolean explicitTrustStoreOnly = false;
    private boolean requireClientAuthentication = false;

    public TlsConfiguration(String keyStore) {
        this.keyStoreName = keyStore;
    }

    public void initialise(boolean anon, String namespace) throws InitialisationException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("initialising: anon " + anon));
        }
        this.validate(anon);
        Security.addProvider(this.provider);
        System.setProperty("java.protocol.handler.pkgs", this.protocolHandler);
        if (!anon) {
            this.initKeyManagerFactory();
        }
        this.initTrustManagerFactory();
        if (null != namespace) {
            new TlsPropertiesMapper(namespace).writeToProperties(System.getProperties(), this);
        }
    }

    private void validate(boolean anon) throws InitialisationException {
        TlsConfiguration.assertNotNull(this.getProvider(), "The security provider cannot be null");
        if (!anon) {
            TlsConfiguration.assertNotNull(this.getKeyStore(), "The KeyStore location cannot be null");
            TlsConfiguration.assertNotNull(this.getKeyPassword(), "The Key password cannot be null");
            TlsConfiguration.assertNotNull(this.getStorePassword(), "The KeyStore password cannot be null");
            TlsConfiguration.assertNotNull(this.getKeyManagerAlgorithm(), "The Key Manager Algorithm cannot be null");
        }
    }

    private void initKeyManagerFactory() throws InitialisationException {
        KeyStore tempKeyStore;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"initialising key manager factory from keystore data");
        }
        try {
            tempKeyStore = KeyStore.getInstance(this.keystoreType);
            InputStream is = IOUtils.getResourceAsStream(this.keyStoreName, this.getClass());
            if (null == is) {
                throw new FileNotFoundException(new Message(122, "Keystore: " + this.keyStoreName).getMessage());
            }
            tempKeyStore.load(is, this.keyStorePassword.toCharArray());
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(58, "KeyStore: " + this.keyStoreName), e, this);
        }
        try {
            this.keyManagerFactory = KeyManagerFactory.getInstance(this.getKeyManagerAlgorithm());
            this.keyManagerFactory.init(tempKeyStore, this.keyPassword.toCharArray());
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(58, "Key Manager"), e, this);
        }
    }

    private void initTrustManagerFactory() throws InitialisationException {
        if (null != this.trustStoreName) {
            KeyStore trustStore;
            this.trustStorePassword = null == this.trustStorePassword ? "" : this.trustStorePassword;
            try {
                trustStore = KeyStore.getInstance(this.trustStoreType);
                InputStream is = IOUtils.getResourceAsStream(this.trustStoreName, this.getClass());
                if (null == is) {
                    throw new FileNotFoundException("Failed to load truststore from classpath or local file: " + this.trustStoreName);
                }
                trustStore.load(is, this.trustStorePassword.toCharArray());
            }
            catch (Exception e) {
                throw new InitialisationException(new Message(58, "TrustStore: " + this.trustStoreName), e, this);
            }
            try {
                this.trustManagerFactory = TrustManagerFactory.getInstance(this.trustManagerAlgorithm);
                this.trustManagerFactory.init(trustStore);
            }
            catch (Exception e) {
                throw new InitialisationException(new Message(58, "Trust Manager (" + this.trustManagerAlgorithm + ")"), e, this);
            }
        }
    }

    private static void assertNotNull(Object value, String message) {
        if (null == value) {
            throw new NullPointerException(message);
        }
    }

    private static String defaultForNull(String value, String deflt) {
        if (null == value) {
            return deflt;
        }
        return value;
    }

    public SSLSocketFactory getSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        return this.getSslContext().getSocketFactory();
    }

    public SSLServerSocketFactory getServerSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        return this.getSslContext().getServerSocketFactory();
    }

    public SSLContext getSslContext() throws NoSuchAlgorithmException, KeyManagementException {
        KeyManager[] keyManagers = null == this.getKeyManagerFactory() ? null : this.getKeyManagerFactory().getKeyManagers();
        TrustManager[] trustManagers = null == this.getTrustManagerFactory() ? null : this.getTrustManagerFactory().getTrustManagers();
        SSLContext context = SSLContext.getInstance(this.getSslType());
        context.init(keyManagers, trustManagers, null);
        return context;
    }

    public String getSslType() {
        return this.sslType;
    }

    public void setSslType(String sslType) {
        this.sslType = sslType;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public String getProtocolHandler() {
        return this.protocolHandler;
    }

    public void setProtocolHandler(String protocolHandler) {
        this.protocolHandler = protocolHandler;
    }

    public SecurityProviderFactory getSecurityProviderFactory() {
        return this.spFactory;
    }

    public void setSecurityProviderFactory(SecurityProviderFactory spFactory) {
        this.spFactory = spFactory;
    }

    public String getKeyStore() {
        return this.keyStoreName;
    }

    public void setKeyStore(String name) throws IOException {
        this.keyStoreName = name;
        if (null != this.keyStoreName) {
            this.keyStoreName = FileUtils.getResourcePath(this.keyStoreName, this.getClass());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Normalised keyStore path to: " + this.keyStoreName));
            }
        }
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getStorePassword() {
        return this.keyStorePassword;
    }

    public void setStorePassword(String storePassword) {
        this.keyStorePassword = storePassword;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public String getKeyManagerAlgorithm() {
        return this.keyManagerAlgorithm;
    }

    public void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        this.keyManagerAlgorithm = keyManagerAlgorithm;
    }

    public KeyManagerFactory getKeyManagerFactory() {
        return this.keyManagerFactory;
    }

    public String getClientKeyStore() {
        return this.clientKeyStoreName;
    }

    public void setClientKeyStore(String name) throws IOException {
        this.clientKeyStoreName = name;
        if (null != this.clientKeyStoreName) {
            this.clientKeyStoreName = FileUtils.getResourcePath(this.clientKeyStoreName, this.getClass());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Normalised clientKeyStore path to: " + this.clientKeyStoreName));
            }
        }
    }

    public String getClientKeyStorePassword() {
        return this.clientKeyStorePassword;
    }

    public void setClientKeyStorePassword(String clientKeyStorePassword) {
        this.clientKeyStorePassword = clientKeyStorePassword;
    }

    public void setClientKeyStoreType(String clientKeyStoreType) {
        this.clientKeyStoreType = clientKeyStoreType;
    }

    public String getClientKeyStoreType() {
        return this.clientKeyStoreType;
    }

    public String getTrustStore() {
        return this.trustStoreName;
    }

    public void setTrustStore(String name) throws IOException {
        this.trustStoreName = name;
        if (null != this.trustStoreName) {
            this.trustStoreName = FileUtils.getResourcePath(this.trustStoreName, this.getClass());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Normalised trustStore path to: " + this.trustStoreName));
            }
        }
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getTrustManagerAlgorithm() {
        return this.trustManagerAlgorithm;
    }

    public void setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        this.trustManagerAlgorithm = TlsConfiguration.defaultForNull(trustManagerAlgorithm, this.spInfo.getKeyManagerAlgorithm());
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    public void setTrustManagerFactory(TrustManagerFactory trustManagerFactory) {
        this.trustManagerFactory = trustManagerFactory;
    }

    public boolean isExplicitTrustStoreOnly() {
        return this.explicitTrustStoreOnly;
    }

    public void setExplicitTrustStoreOnly(boolean explicitTrustStoreOnly) {
        this.explicitTrustStoreOnly = explicitTrustStoreOnly;
    }

    public boolean isRequireClientAuthentication() {
        return this.requireClientAuthentication;
    }

    public void setRequireClientAuthentication(boolean requireClientAuthentication) {
        this.requireClientAuthentication = requireClientAuthentication;
    }
}

