/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.MuleConfiguration;
import org.mule.impl.MuleDescriptor;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOException;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.model.UMOModel;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.FileUtils;
import org.mule.util.StringMessageUtils;

public abstract class AbstractMuleTestCase
extends TestCase {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected String prereqs = null;
    private boolean offline = System.getProperty("org.mule.offline", "false").equalsIgnoreCase("true");
    private boolean testLogging = System.getProperty("org.mule.test.logging", "false").equalsIgnoreCase("true");
    private static Map testCounters;

    public AbstractMuleTestCase() {
        if (testCounters == null) {
            testCounters = new HashMap();
        }
        this.addTest();
    }

    protected void addTest() {
        TestInfo info = (TestInfo)testCounters.get(((Object)((Object)this)).getClass().getName());
        if (info == null) {
            info = new TestInfo(((Object)((Object)this)).getClass().getName());
            testCounters.put(((Object)((Object)this)).getClass().getName(), info);
        }
        info.incTestCount();
    }

    protected void setDisposeManagerPerSuite(boolean val) {
        this.getTestInfo().setDisposeManagerPerSuite(val);
    }

    protected TestInfo getTestInfo() {
        TestInfo info = (TestInfo)testCounters.get(((Object)((Object)this)).getClass().getName());
        if (info == null) {
            info = new TestInfo(((Object)((Object)this)).getClass().getName());
            testCounters.put(((Object)((Object)this)).getClass().getName(), info);
        }
        return info;
    }

    private void clearAllCounters() {
        if (testCounters != null) {
            testCounters.clear();
        }
        this.log("Cleared all counters");
    }

    private void clearCounter() {
        if (testCounters != null) {
            testCounters.remove(((Object)((Object)this)).getClass().getName());
        }
        this.log("Cleared counter: " + ((Object)((Object)this)).getClass().getName());
    }

    private void log(String s) {
        if (this.testLogging) {
            System.err.println(s);
        }
    }

    public String getName() {
        return super.getName().substring(4).replaceAll("([A-Z])", " $1").toLowerCase() + " ";
    }

    protected String checkPreReqs() {
        return null;
    }

    public boolean isOffline(String method) {
        if (this.offline) {
            System.out.println(StringMessageUtils.getBoilerPlate("Working offline cannot run test: " + method, '=', 80));
        }
        return this.offline;
    }

    public boolean isPrereqsMet(String method) {
        this.prereqs = this.checkPreReqs();
        if (this.prereqs != null) {
            System.out.println(StringMessageUtils.getBoilerPlate("WARNING\nPrerequisites for test: " + method + " were not met. skipping test: " + this.prereqs, '=', 80));
        }
        return this.prereqs == null;
    }

    protected final void setUp() throws Exception {
        System.out.println(StringMessageUtils.getBoilerPlate("Testing: " + this.toString(), '=', 80));
        MuleManager.getConfiguration().getDefaultThreadingProfile().setDoThreading(false);
        MuleManager.getConfiguration().setServerUrl("");
        try {
            if (this.getTestInfo().getRunCount() == 0) {
                if (this.getTestInfo().isDisposeManagerPerSuite()) {
                    this.disposeManager();
                }
                this.log("Pre suiteSetup for test: " + this.getTestInfo());
                this.suitePreSetUp();
            }
            if (!this.getTestInfo().isDisposeManagerPerSuite()) {
                this.disposeManager();
            }
            if (!this.isPrereqsMet(((Object)((Object)this)).getClass().getName() + ".setUp()")) {
                return;
            }
            this.doSetUp();
            if (this.getTestInfo().getRunCount() == 0) {
                this.log("Post suiteSetup for test: " + this.getTestInfo());
                this.suitePostSetUp();
            }
        }
        catch (Exception e) {
            this.getTestInfo().incRunCount();
            throw e;
        }
    }

    protected void suitePreSetUp() throws Exception {
    }

    protected void suitePostSetUp() throws Exception {
    }

    protected void suitePreTearDown() throws Exception {
    }

    protected void suitePostTearDown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void tearDown() throws Exception {
        try {
            if (this.getTestInfo().getRunCount() == this.getTestInfo().getTestCount()) {
                this.log("Pre suiteTearDown for test: " + this.getTestInfo());
                this.suitePreTearDown();
            }
            this.doTearDown();
            if (!this.getTestInfo().isDisposeManagerPerSuite()) {
                this.disposeManager();
            }
            Object var2_1 = null;
            this.getTestInfo().incRunCount();
            if (this.getTestInfo().getRunCount() != this.getTestInfo().getTestCount()) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.getTestInfo().incRunCount();
            if (this.getTestInfo().getRunCount() != this.getTestInfo().getTestCount()) throw throwable;
            try {
                this.log("Post suiteTearDown for test: " + this.getTestInfo());
                this.suitePostTearDown();
                throw throwable;
            }
            finally {
                this.clearCounter();
                this.disposeManager();
            }
        }
        try {
            this.log("Post suiteTearDown for test: " + this.getTestInfo());
            this.suitePostTearDown();
            return;
        }
        finally {
            this.clearCounter();
            this.disposeManager();
        }
    }

    protected void disposeManager() throws UMOException {
        this.log("disposing manager. disposeManagerPerSuite=" + this.getTestInfo().isDisposeManagerPerSuite());
        if (MuleManager.isInstanciated()) {
            MuleManager.getInstance().dispose();
        }
        FileUtils.deleteTree(FileUtils.newFile(MuleManager.getConfiguration().getWorkingDirectory()));
        FileUtils.deleteTree(FileUtils.newFile("./ActiveMQ"));
        MuleManager.setConfiguration(new MuleConfiguration());
    }

    protected void doSetUp() throws Exception {
    }

    protected void doTearDown() throws Exception {
    }

    public static UMOManager getManager(boolean disableAdminAgent) throws Exception {
        return MuleTestUtils.getManager(disableAdminAgent);
    }

    public static UMOModel getDefaultModel() throws UMOException {
        return MuleTestUtils.getDefaultModel();
    }

    public static UMOEndpoint getTestEndpoint(String name, String type) throws Exception {
        return MuleTestUtils.getTestEndpoint(name, type);
    }

    public static UMOEvent getTestEvent(Object data) throws Exception {
        return MuleTestUtils.getTestEvent(data);
    }

    public static UMOEventContext getTestEventContext(Object data) throws Exception {
        return MuleTestUtils.getTestEventContext(data);
    }

    public static UMOTransformer getTestTransformer() {
        return MuleTestUtils.getTestTransformer();
    }

    public static UMOEvent getTestEvent(Object data, MuleDescriptor descriptor) throws Exception {
        return MuleTestUtils.getTestEvent(data, descriptor);
    }

    public static UMOEvent getTestEvent(Object data, UMOImmutableEndpoint endpoint) throws Exception {
        return MuleTestUtils.getTestEvent(data, endpoint);
    }

    public static UMOEvent getTestEvent(Object data, MuleDescriptor descriptor, UMOImmutableEndpoint endpoint) throws UMOException {
        return MuleTestUtils.getTestEvent(data, descriptor, endpoint);
    }

    public static UMOSession getTestSession(UMOComponent component) {
        return MuleTestUtils.getTestSession(component);
    }

    public static TestConnector getTestConnector() {
        return MuleTestUtils.getTestConnector();
    }

    public static UMOComponent getTestComponent(MuleDescriptor descriptor) {
        return MuleTestUtils.getTestComponent(descriptor);
    }

    public static MuleDescriptor getTestDescriptor(String name, String implementation) throws Exception {
        return MuleTestUtils.getTestDescriptor(name, implementation);
    }

    public static UMOManager getTestManager() throws Exception {
        return MuleTestUtils.getManager(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.clearAllCounters();
        }
        finally {
            super.finalize();
        }
    }

    protected class TestInfo {
        private boolean disposeManagerPerSuite = false;
        private int testCount = 0;
        private int runCount = 0;
        private String name;

        public TestInfo(String name) {
            this.name = name;
        }

        public void clearCounts() {
            this.testCount = 0;
            this.runCount = 0;
            AbstractMuleTestCase.this.log("Cleared counts for: " + this.name);
        }

        public void incTestCount() {
            ++this.testCount;
            AbstractMuleTestCase.this.log("Added test: " + this.name + " " + this.testCount);
        }

        public void incRunCount() {
            ++this.runCount;
            AbstractMuleTestCase.this.log("Finished Run: " + this.toString());
        }

        public int getTestCount() {
            return this.testCount;
        }

        public int getRunCount() {
            return this.runCount;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDisposeManagerPerSuite() {
            return this.disposeManagerPerSuite;
        }

        public void setDisposeManagerPerSuite(boolean disposeManagerPerSuite) {
            this.disposeManagerPerSuite = disposeManagerPerSuite;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            return buf.append(this.name).append(", (").append(this.runCount).append(" / ").append(this.testCount).append(") tests run, disposePerSuite=").append(this.disposeManagerPerSuite).toString();
        }
    }
}

