/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.UMOConnector;

public class ObjectNameHelper {
    public static final String SEPARATOR = ".";
    public static final char HASH = '#';
    public static final String CONNECTOR_PREFIX = "_connector";
    public static final String ENDPOINT_PREFIX = "_endpoint";
    static transient Log logger = LogFactory.getLog((Class)ObjectNameHelper.class);

    public static String getEndpointName(UMOImmutableEndpoint endpoint) {
        String name = endpoint.getName();
        if (name != null) {
            if (name.equals(endpoint.getEndpointURI().getAddress())) {
                name = endpoint.getEndpointURI().getScheme() + SEPARATOR + name;
            }
            return ObjectNameHelper.replaceObjectNameChars(name);
        }
        String address = endpoint.getEndpointURI().getAddress();
        address = address.indexOf(":/") > -1 ? address : endpoint.getEndpointURI().getScheme() + SEPARATOR + address;
        name = "_endpoint." + ObjectNameHelper.replaceObjectNameChars(address);
        int i = 0;
        while (MuleManager.getInstance().lookupEndpoint(name) != null) {
            name = "_endpoint." + ObjectNameHelper.replaceObjectNameChars(endpoint.getEndpointURI().getAddress()) + SEPARATOR + ++i;
        }
        return name;
    }

    public static String getConnectorName(UMOConnector connector) {
        if (connector.getName() != null && connector.getName().indexOf("#") == -1) {
            return ObjectNameHelper.replaceObjectNameChars(connector.getName());
        }
        int i = 0;
        String name = "_connector." + connector.getProtocol() + SEPARATOR + i;
        while (MuleManager.getInstance().lookupConnector(name) != null) {
            name = "_connector." + connector.getProtocol() + SEPARATOR + ++i;
        }
        return name;
    }

    public static String replaceObjectNameChars(String name) {
        String value = name.replaceAll("//", SEPARATOR);
        value = value.replaceAll("/", SEPARATOR);
        value = value.replaceAll("\\?", SEPARATOR);
        value = value.replaceAll("&", SEPARATOR);
        value = value.replaceAll(":", SEPARATOR);
        value = value.replaceAll("=", "-");
        value = value.replaceAll("\\.\\.", SEPARATOR);
        return value;
    }
}

