/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.response;

import org.mule.routing.inbound.EventGroup;
import org.mule.routing.response.AbstractResponseAggregator;
import org.mule.umo.UMOEvent;

public abstract class ResponseCorrelationAggregator
extends AbstractResponseAggregator {
    protected boolean shouldAggregate(EventGroup events) {
        int expected = events.expectedSize();
        if (expected == -1) {
            this.logger.warn((Object)"Correlation Group Size not set, but CorrelationAggregator is being used.  Message is being forwarded");
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info((Object)("Aggregator: EventGroups size = " + this.eventGroups.size()));
            this.logger.info((Object)("Correlation size is " + expected + ". current event group size is " + events.size() + " for correlation " + events.getGroupId()));
        }
        return expected == events.size();
    }

    protected EventGroup createEventGroup(Object id, UMOEvent event) {
        int groupSize = event.getMessage().getCorrelationGroupSize();
        return new EventGroup(id, groupSize);
    }
}

