/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.response;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.routing.inbound.EventGroup;
import org.mule.routing.response.AbstractResponseRouter;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.routing.ResponseTimeoutException;
import org.mule.umo.routing.RoutingException;
import org.mule.util.PropertiesUtils;
import org.mule.util.concurrent.Latch;

public abstract class AbstractResponseAggregator
extends AbstractResponseRouter {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected ConcurrentMap responseEvents = new ConcurrentHashMap();
    private ConcurrentMap locks = new ConcurrentHashMap();
    protected final ConcurrentMap eventGroups = new ConcurrentHashMap();

    public void process(UMOEvent event) throws RoutingException {
        EventGroup eg = this.addEvent(event);
        if (this.shouldAggregate(eg)) {
            UMOMessage returnMessage = this.aggregateEvents(eg);
            Object id = eg.getGroupId();
            this.removeEventGroup(id);
            UMOMessage previousResult = (UMOMessage)this.responseEvents.putIfAbsent(id, (Object)returnMessage);
            if (previousResult != null) {
                throw new IllegalStateException("Detected duplicate aggregation result message with id: " + id);
            }
            Latch l = (Latch)((Object)this.locks.get(id));
            if (l == null) {
                Latch previous;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Creating latch for " + id + " in " + this));
                }
                if ((previous = (Latch)((Object)this.locks.putIfAbsent(id, (Object)(l = new Latch())))) != null) {
                    l = previous;
                }
            }
            l.countDown();
        }
    }

    protected EventGroup addEvent(UMOEvent event) throws RoutingException {
        EventGroup previous;
        EventGroup eg;
        Object cId = this.getReplyAggregateIdentifier(event.getMessage());
        if (cId == null || cId.equals("-1")) {
            throw new RoutingException(new Message(66), event.getMessage(), event.getEndpoint());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding event to response aggregator group: " + cId));
        }
        if ((eg = (EventGroup)this.eventGroups.get(cId)) == null && (previous = (EventGroup)this.eventGroups.putIfAbsent((eg = this.createEventGroup(cId, event)).getGroupId(), (Object)eg)) != null) {
            eg = previous;
        }
        eg.addEvent(event);
        return eg;
    }

    protected EventGroup createEventGroup(Object id, UMOEvent event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating new event group: " + id + " in " + this));
        }
        return new EventGroup(id);
    }

    protected void removeEventGroup(Object id) {
        this.eventGroups.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UMOMessage getResponse(UMOMessage message) throws RoutingException {
        void var4_4;
        boolean b;
        Object responseId;
        block16: {
            UMOMessage result;
            Latch l;
            responseId = this.getCallResponseAggregateIdentifier(message);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Waiting for response for message id: " + responseId + " in " + this));
            }
            if ((l = (Latch)((Object)this.locks.get(responseId))) == null) {
                Latch previous;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Got response but no one is waiting for it yet. Creating latch for " + responseId + " in " + this));
                }
                if ((previous = (Latch)((Object)this.locks.putIfAbsent(responseId, (Object)(l = new Latch())))) != null) {
                    l = previous;
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Got latch for message: " + responseId));
            }
            b = false;
            try {
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Waiting for response to message: " + responseId));
                    }
                    if (this.getTimeout() <= 0) {
                        l.await();
                        b = true;
                    } else {
                        b = l.await(this.getTimeout(), TimeUnit.MILLISECONDS);
                    }
                }
                catch (InterruptedException e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                    Object var8_7 = null;
                    this.locks.remove(responseId);
                    result = (UMOMessage)this.responseEvents.remove(responseId);
                    break block16;
                }
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.locks.remove(responseId);
                result = (UMOMessage)this.responseEvents.remove(responseId);
                throw throwable;
            }
            this.locks.remove(responseId);
            result = (UMOMessage)this.responseEvents.remove(responseId);
        }
        if (!b) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Current responses are: \n" + PropertiesUtils.propertiesToString((Map)this.responseEvents, true)));
            }
            throw new ResponseTimeoutException(new Message(90, String.valueOf(this.getTimeout()), responseId), message, null);
        }
        if (var4_4 == null) {
            throw new IllegalStateException("Response Message is null");
        }
        return var4_4;
    }

    protected abstract boolean shouldAggregate(EventGroup var1);

    protected abstract UMOMessage aggregateEvents(EventGroup var1) throws RoutingException;
}

