/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.impl.UMODescriptorAware;
import org.mule.model.DynamicEntryPoint;
import org.mule.model.DynamicEntryPointResolver;
import org.mule.umo.ComponentException;
import org.mule.umo.Invocation;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.Startable;
import org.mule.umo.lifecycle.Stoppable;
import org.mule.umo.lifecycle.UMOLifecycleAdapter;
import org.mule.umo.model.UMOEntryPointResolver;

public class DefaultLifecycleAdapter
implements UMOLifecycleAdapter {
    protected static transient Log logger = LogFactory.getLog((Class)DefaultLifecycleAdapter.class);
    private Object component;
    private UMODescriptor descriptor;
    private boolean isStoppable = false;
    private boolean isStartable = false;
    private boolean isDisposable = false;
    private boolean started = false;
    private boolean disposed = false;
    private DynamicEntryPoint entryPoint;

    public DefaultLifecycleAdapter(Object component, UMODescriptor descriptor) throws UMOException {
        this(component, descriptor, new DynamicEntryPointResolver());
    }

    public DefaultLifecycleAdapter(Object component, UMODescriptor descriptor, UMOEntryPointResolver epResolver) throws UMOException {
        this.initialise(component, descriptor, epResolver);
    }

    protected void initialise(Object component, UMODescriptor descriptor, UMOEntryPointResolver epDiscovery) throws UMOException {
        if (component == null) {
            throw new IllegalArgumentException("Component cannot be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Descriptor cannot be null");
        }
        if (epDiscovery == null) {
            epDiscovery = new DynamicEntryPointResolver();
        }
        this.component = component;
        this.entryPoint = (DynamicEntryPoint)epDiscovery.resolveEntryPoint(descriptor);
        this.descriptor = descriptor;
        this.isStartable = Startable.class.isInstance(component);
        this.isStoppable = Stoppable.class.isInstance(component);
        this.isDisposable = Disposable.class.isInstance(component);
        if (component instanceof UMODescriptorAware) {
            ((UMODescriptorAware)component).setDescriptor(descriptor);
        }
    }

    public void start() throws UMOException {
        if (this.isStartable) {
            try {
                ((Startable)this.component).start();
            }
            catch (Exception e) {
                throw new MuleException(new Message(42, "UMO Component: " + this.descriptor.getName()), (Throwable)e);
            }
        }
        this.started = true;
    }

    public void stop() throws UMOException {
        if (this.isStoppable) {
            try {
                ((Stoppable)this.component).stop();
            }
            catch (Exception e) {
                throw new MuleException(new Message(41, "UMO Component: " + this.descriptor.getName()), (Throwable)e);
            }
        }
        this.started = false;
    }

    public void dispose() {
        if (this.isDisposable) {
            try {
                ((Disposable)this.component).dispose();
            }
            catch (Exception e) {
                logger.error((Object)("failed to dispose: " + this.descriptor.getName()), (Throwable)e);
            }
        }
        this.disposed = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public UMODescriptor getDescriptor() {
        return this.descriptor;
    }

    public void handleException(Object message, Exception e) {
        this.descriptor.getExceptionListener().exceptionThrown(e);
    }

    public UMOMessage intercept(Invocation invocation) throws UMOException {
        Object result;
        UMOEvent event = RequestContext.getEvent();
        try {
            result = this.entryPoint.invoke(this.component, RequestContext.getEventContext());
        }
        catch (Exception e) {
            throw new ComponentException(new Message(68, this.component.getClass().getName()), invocation.getMessage(), event.getComponent(), e);
        }
        UMOMessage resultMessage = null;
        if (result == null && this.entryPoint.isVoid()) {
            resultMessage = new MuleMessage(event.getTransformedMessage(), RequestContext.getEventContext().getMessage());
        } else if (result != null) {
            resultMessage = result instanceof UMOMessage ? (UMOMessage)result : new MuleMessage(result, event.getMessage());
        }
        return resultMessage;
    }

    public void initialise() throws InitialisationException {
        if (Initialisable.class.isInstance(this.component)) {
            ((Initialisable)this.component).initialise();
        }
    }
}

