/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.converters;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.mule.MuleManager;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.manager.UMOManager;

public class EndpointConverter
implements Converter {
    public Object convert(Class type, Object value) {
        UMOManager manager = MuleManager.getInstance();
        if (value == null) {
            throw new ConversionException("No value specified");
        }
        if (value instanceof UMOEndpoint) {
            return value;
        }
        try {
            String endpointString = manager.lookupEndpointIdentifier(value.toString(), value.toString());
            UMOImmutableEndpoint globalEndpoint = (UMOImmutableEndpoint)manager.getEndpoints().get(endpointString);
            if (globalEndpoint == null) {
                MuleEndpointURI endpointUri = new MuleEndpointURI(endpointString);
                if (!endpointString.equals(value.toString())) {
                    endpointUri.setEndpointName(value.toString());
                }
                UMOEndpoint endpoint = MuleEndpoint.createEndpointFromUri(endpointUri, null);
                if (endpointUri.getEndpointName() == null && !endpointString.equals(value.toString())) {
                    endpoint.setName(value.toString());
                }
                return endpoint;
            }
            return null;
        }
        catch (Exception e) {
            throw new ConversionException((Throwable)e);
        }
    }
}

