/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.MuleObjectHelper;

public class TransformerReference {
    protected static transient Log logger = LogFactory.getLog((Class)TransformerReference.class);
    private String propertyName;
    private String transformerName;
    private Object object;

    public TransformerReference(String propertyName, String transformerName, Object object) {
        this.propertyName = propertyName;
        this.transformerName = transformerName;
        this.object = object;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getTransformerName() {
        return this.transformerName;
    }

    public Object getObject() {
        return this.object;
    }

    public void resolveTransformer() throws InitialisationException {
        UMOTransformer trans = null;
        try {
            trans = MuleObjectHelper.getTransformer(this.transformerName, " ");
            if (trans == null) {
                throw new InitialisationException(new Message(82, "Transformer '" + this.transformerName + "'"), this.object);
            }
            logger.info((Object)("Setting transformer: " + this.transformerName + " on " + this.object.getClass().getName() + "." + this.propertyName));
            BeanUtils.setProperty((Object)this.object, (String)this.propertyName, (Object)trans);
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(61, this.propertyName, (Object)(this.object != null ? this.object.getClass().getName() : "null"), (Object)(trans != null ? trans.getClass().getName() : "null")), e, this);
        }
    }
}

