/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.compression;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.compression.CompressionStrategy;

public class GZipCompression
implements CompressionStrategy {
    private static final Log logger = LogFactory.getLog((Class)GZipCompression.class);

    public boolean isCompressed(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length < 2) {
            return false;
        }
        return bytes[0] == 31 && bytes[1] == -117;
    }

    public byte[] compressByteArray(byte[] bytes) throws IOException {
        byte[] byArray;
        if (bytes == null || this.isCompressed(bytes)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Data already compressed; doing nothing");
            }
            return bytes;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Compressing message of size: " + bytes.length));
        }
        ByteArrayOutputStream baos = null;
        GZIPOutputStream gzos = null;
        try {
            baos = new ByteArrayOutputStream(32768);
            gzos = new GZIPOutputStream((OutputStream)baos);
            gzos.write(bytes, 0, bytes.length);
            gzos.finish();
            gzos.close();
            byte[] compressedByteArray = baos.toByteArray();
            baos.close();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Compressed message to size: " + compressedByteArray.length));
            }
            byArray = compressedByteArray;
        }
        catch (IOException ioex) {
            try {
                throw ioex;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(gzos);
                IOUtils.closeQuietly((OutputStream)baos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)gzos);
        IOUtils.closeQuietly((OutputStream)baos);
        return byArray;
    }

    public byte[] uncompressByteArray(byte[] bytes) throws IOException {
        byte[] byArray;
        if (!this.isCompressed(bytes)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Data already uncompressed; doing nothing");
            }
            return bytes;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Uncompressing message of size: " + bytes.length));
        }
        ByteArrayInputStream bais = null;
        GZIPInputStream gzis = null;
        ByteArrayOutputStream baos = null;
        try {
            bais = new ByteArrayInputStream(bytes);
            gzis = new GZIPInputStream(bais);
            baos = new ByteArrayOutputStream(32768);
            IOUtils.copy((InputStream)gzis, (OutputStream)baos);
            gzis.close();
            bais.close();
            byte[] uncompressedByteArray = baos.toByteArray();
            baos.close();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Uncompressed message to size: " + uncompressedByteArray.length));
            }
            byArray = uncompressedByteArray;
        }
        catch (IOException ioex) {
            try {
                throw ioex;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(gzis);
                IOUtils.closeQuietly((InputStream)bais);
                IOUtils.closeQuietly(baos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)gzis);
        IOUtils.closeQuietly((InputStream)bais);
        IOUtils.closeQuietly((OutputStream)baos);
        return byArray;
    }
}

