/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TemplateParser {
    public static final String ANT_TEMPLATE_STYLE = "ant";
    public static final String SQUARE_TEMPLATE_STYLE = "square";
    protected static Log logger = LogFactory.getLog((Class)TemplateParser.class);
    private Pattern pattern = null;
    private int pre = 1;
    private int post = 1;
    private String style = null;

    public static TemplateParser createAntStyleParser() {
        return new TemplateParser(ANT_TEMPLATE_STYLE);
    }

    public static TemplateParser createSquareBracesStyleParser() {
        return new TemplateParser(SQUARE_TEMPLATE_STYLE);
    }

    private TemplateParser(String style) {
        if (ANT_TEMPLATE_STYLE.equals(style)) {
            this.pattern = Pattern.compile("\\$\\{[^\\}]+\\}");
            this.pre = 2;
        } else if (SQUARE_TEMPLATE_STYLE.equals(style)) {
            this.pattern = Pattern.compile("\\[[^\\]]+\\]");
        } else {
            throw new IllegalArgumentException("Unknown template style: " + style);
        }
        this.style = style;
    }

    public String parse(Map props, String template) {
        return this.parse(props, template, null);
    }

    public String parse(TemplateCallback callback, String template) {
        return this.parse(null, template, callback);
    }

    protected String parse(Map props, String template, TemplateCallback callback) {
        String result = template;
        Matcher m = this.pattern.matcher(template);
        while (m.find()) {
            Object value = null;
            String match = m.group();
            String propname = match.substring(this.pre, match.length() - this.post);
            if (callback != null) {
                value = callback.match(propname);
            } else if (props != null) {
                value = props.get(propname);
            }
            if (value == null) {
                if (!logger.isWarnEnabled()) continue;
                logger.warn((Object)("Value " + propname + " not found in context"));
                continue;
            }
            String matchRegex = this.escape(match);
            String valueString = value.toString();
            if (valueString.indexOf(92) != -1) {
                valueString = valueString.replaceAll("\\\\", "\\\\\\\\");
            }
            result = result.replaceAll(matchRegex, valueString);
        }
        return result;
    }

    public List parse(Map props, List templates) {
        if (templates == null) {
            return new ArrayList();
        }
        ArrayList<String> list = new ArrayList<String>(templates.size());
        Iterator iterator = templates.iterator();
        while (iterator.hasNext()) {
            list.add(this.parse(props, iterator.next().toString()));
        }
        return list;
    }

    public Map parse(Map props, Map templates) {
        if (templates == null) {
            return new HashMap();
        }
        HashMap map = new HashMap(templates.size());
        Iterator iterator = templates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            map.put(entry.getKey(), this.parse(props, entry.getValue().toString()));
        }
        return map;
    }

    private String escape(String string) {
        int length = string.length();
        if (length == 0) {
            return string;
        }
        StringBuffer buffer = new StringBuffer(length * 2);
        for (int i = 0; i < length; ++i) {
            char currentCharacter = string.charAt(i);
            switch (currentCharacter) {
                case '$': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    buffer.append("\\");
                }
            }
            buffer.append(currentCharacter);
        }
        return buffer.toString();
    }

    public String getStyle() {
        return this.style;
    }

    public boolean isContainsTemplate(String value) {
        Matcher m = this.pattern.matcher(value);
        return m.find();
    }

    public static interface TemplateCallback {
        public Object match(String var1);
    }
}

