/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.routing.filters.ObjectFilter;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOMessage;
import org.mule.util.StringUtils;

public class WildcardFilter
implements UMOFilter,
ObjectFilter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected String pattern;
    protected String[] patterns;
    private boolean caseSensitive = true;

    public WildcardFilter() {
    }

    public WildcardFilter(String pattern) {
        this.setPattern(pattern);
    }

    public boolean accept(UMOMessage message) {
        try {
            return this.accept(message.getPayloadAsString());
        }
        catch (Exception e) {
            this.logger.warn((Object)"An exception occured while filtering", (Throwable)e);
            return false;
        }
    }

    public boolean accept(Object object) {
        if (object == null) {
            return false;
        }
        if (this.patterns != null) {
            for (int x = 0; x < this.patterns.length; ++x) {
                int i2;
                int i;
                boolean foundMatch;
                String pattern = this.patterns[x];
                if ("*".equals(pattern) || "**".equals(pattern)) {
                    return true;
                }
                String candidate = object.toString();
                if (!this.isCaseSensitive()) {
                    pattern = pattern.toLowerCase();
                    candidate = candidate.toLowerCase();
                }
                if (!(foundMatch = (i = pattern.indexOf(42)) == -1 ? pattern.equals(candidate) : ((i2 = pattern.indexOf(42, i + 1)) > 1 ? candidate.indexOf(pattern.substring(1, i2)) > -1 : (i == 0 ? candidate.endsWith(pattern.substring(1)) : candidate.startsWith(pattern.substring(0, i)))))) continue;
                return true;
            }
        }
        return false;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.patterns = StringUtils.splitAndTrim(pattern, ",");
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }
}

