/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.notifications;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.internal.notifications.BlockingServerEvent;
import org.mule.impl.internal.notifications.NotificationException;
import org.mule.routing.filters.WildcardFilter;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.LifecycleException;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.manager.UMOServerNotificationListener;
import org.mule.umo.manager.UMOWorkManager;

public class ServerNotificationManager
implements Work,
Disposable {
    protected static final Log logger = LogFactory.getLog((Class)ServerNotificationManager.class);
    public static final String NULL_SUBSCRIPTION = "NULL";
    private Map eventsMap = null;
    private LinkedBlockingQueue eventQueue;
    private boolean disposed = false;
    private List listeners;
    private WorkListener workListener;

    public ServerNotificationManager() {
        this.init();
    }

    private synchronized void init() {
        this.eventsMap = new ConcurrentHashMap();
        this.eventQueue = new LinkedBlockingQueue();
        this.listeners = new CopyOnWriteArrayList();
        this.workListener = MuleManager.getConfiguration().getWorkListener();
    }

    public void start(UMOWorkManager workManager) throws LifecycleException {
        try {
            workManager.scheduleWork(this, Long.MAX_VALUE, null, this.workListener);
        }
        catch (WorkException e) {
            throw new LifecycleException(e, (Object)this);
        }
    }

    public void registerEventType(Class eventType, Class listenerType) {
        if (UMOServerNotification.class.isAssignableFrom(eventType)) {
            if (!this.eventsMap.containsKey(listenerType)) {
                this.eventsMap.put(listenerType, eventType);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Registered event type: " + eventType));
                    logger.debug((Object)("Binding listener type '" + listenerType + "' to event type '" + eventType + "'"));
                }
            }
        } else {
            throw new IllegalArgumentException(new Message(157, "eventType", (Object)UMOServerNotification.class.getName(), (Object)eventType.getName()).getMessage());
        }
    }

    public void registerListener(UMOServerNotificationListener listener) throws NotificationException {
        this.registerListener(listener, null);
    }

    public void registerListener(UMOServerNotificationListener listener, String subscription) throws NotificationException {
        this.listeners.add(new Listener(listener, subscription));
    }

    public void unregisterListener(UMOServerNotificationListener listener) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Listener l = (Listener)iterator.next();
            if (!l.getListenerObject().equals(listener)) continue;
            this.listeners.remove(l);
            break;
        }
    }

    public void clear() {
        this.listeners.clear();
        this.init();
    }

    public void fireEvent(UMOServerNotification notification) {
        if (this.disposed) {
            return;
        }
        if (notification instanceof BlockingServerEvent) {
            this.notifyListeners(notification);
            return;
        }
        try {
            this.eventQueue.put((Object)notification);
        }
        catch (InterruptedException e) {
            logger.error((Object)("Failed to queue notification: " + notification), (Throwable)e);
        }
    }

    public void dispose() {
        this.disposed = true;
        this.clear();
    }

    protected void notifyListeners(UMOServerNotification notification) {
        if (this.disposed) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Listener listener = (Listener)iterator.next();
            if (!listener.matches(notification)) continue;
            listener.getListenerObject().onNotification(notification);
        }
    }

    public void release() {
        this.dispose();
    }

    public void run() {
        UMOServerNotification notification = null;
        while (!this.disposed) {
            try {
                notification = (UMOServerNotification)this.eventQueue.take();
                if (notification == null) continue;
                this.notifyListeners(notification);
            }
            catch (InterruptedException e) {
                if (this.disposed) continue;
                logger.error((Object)"Failed to take notificationication from server notificationication queue", (Throwable)e);
            }
        }
    }

    public WorkListener getWorkListener() {
        return this.workListener;
    }

    public void setWorkListener(WorkListener workListener) {
        if (workListener == null) {
            throw new NullPointerException("workListener");
        }
        this.workListener = workListener;
    }

    protected class Listener {
        private final UMOServerNotificationListener listener;
        private final List notificationClasses;
        private final String subscription;
        private final WildcardFilter subscriptionFilter;

        public Listener(UMOServerNotificationListener listener, String subscription) {
            this.listener = listener;
            this.subscription = subscription == null ? ServerNotificationManager.NULL_SUBSCRIPTION : subscription;
            this.subscriptionFilter = new WildcardFilter(this.subscription);
            this.subscriptionFilter.setCaseSensitive(false);
            this.notificationClasses = new ArrayList();
            Iterator iterator = ServerNotificationManager.this.eventsMap.keySet().iterator();
            while (iterator.hasNext()) {
                Class clazz = (Class)iterator.next();
                if (!clazz.isAssignableFrom(listener.getClass())) continue;
                this.notificationClasses.add(ServerNotificationManager.this.eventsMap.get(clazz));
            }
        }

        public UMOServerNotificationListener getListenerObject() {
            return this.listener;
        }

        public List getNotificationClasses() {
            return this.notificationClasses;
        }

        public String getSubscription() {
            return this.subscription;
        }

        public boolean matches(UMOServerNotification notification) {
            if (this.subscriptionMatches(notification)) {
                Iterator iterator = this.notificationClasses.iterator();
                while (iterator.hasNext()) {
                    Class notificationClass = (Class)iterator.next();
                    if (!notificationClass.isAssignableFrom(notification.getClass())) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean subscriptionMatches(UMOServerNotification notification) {
            String resourceId = notification.getResourceIdentifier();
            return ServerNotificationManager.NULL_SUBSCRIPTION.equals(this.subscription) || this.subscriptionFilter.accept(resourceId);
        }
    }
}

