/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.codec;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.mule.config.i18n.Message;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.transformer.TransformerException;

public class UUDecoder
extends AbstractTransformer {
    private static final long serialVersionUID = -3570019318835185793L;
    private sun.misc.UUDecoder decoder;

    public UUDecoder() {
        this.registerSourceType(String.class);
        this.registerSourceType([B.class);
        this.setReturnClass(String.class);
        this.decoder = new sun.misc.UUDecoder();
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        String data = null;
        if (src instanceof byte[]) {
            if (encoding != null) {
                try {
                    data = new String((byte[])src, encoding);
                }
                catch (UnsupportedEncodingException ex) {
                    data = new String((byte[])src);
                }
            } else {
                data = new String((byte[])src);
            }
        } else {
            data = (String)src;
        }
        try {
            byte[] result = this.decoder.decodeBuffer(data);
            if (this.getReturnClass().equals(String.class)) {
                if (encoding != null) {
                    return new String(result, encoding);
                }
                return new String(result);
            }
            return result;
        }
        catch (IOException e) {
            throw new TransformerException(new Message(55, "UU Encoding"), this, e);
        }
    }
}

