/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.admin;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.net.SocketAppender;
import org.apache.log4j.xml.DOMConfigurator;
import org.mule.config.i18n.Message;
import org.mule.impl.internal.admin.AbstractNotificationLoggerAgent;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.util.FileUtils;

public class Log4jNotificationLoggerAgent
extends AbstractNotificationLoggerAgent {
    protected Logger eventLogger;
    private String logName = Log4jNotificationLoggerAgent.class.getName();
    private String logFile = null;
    private String logConfigFile = null;
    private String chainsawHost = "localhost";
    private int chainsawPort = -1;
    private Map levelMappings = new HashMap();

    public String getDescription() {
        StringBuffer buf = new StringBuffer(64);
        if (StringUtils.isNotBlank((String)this.logFile)) {
            buf.append("Logging notifications to: ").append(this.logFile);
        }
        if (this.chainsawPort > -1) {
            buf.append(" Chainsaw: ").append(this.chainsawHost).append(":").append(this.chainsawPort);
        }
        if (buf.length() == 0) {
            buf.append("No logging or event forwarding is configured");
        }
        return this.getName() + ": " + buf.toString();
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String logName) {
        this.logName = logName;
    }

    public void doInitialise() throws InitialisationException {
        if (this.logConfigFile != null) {
            if (this.logConfigFile.endsWith(".xml")) {
                DOMConfigurator.configure((String)this.logConfigFile);
            } else {
                PropertyConfigurator.configure((String)this.logConfigFile);
            }
        } else {
            try {
                this.eventLogger = Logger.getLogger((String)this.logName);
                if (this.logFile != null) {
                    File f = FileUtils.newFile(this.logFile);
                    if (!f.exists()) {
                        FileUtils.createFile(this.logFile);
                    }
                    RollingFileAppender file = new RollingFileAppender((Layout)new PatternLayout("%5p %m%n"), this.logFile, true);
                    this.eventLogger.addAppender((Appender)file);
                }
                if (this.chainsawPort > -1) {
                    SocketAppender chainsaw = new SocketAppender(this.chainsawHost, this.chainsawPort);
                    this.eventLogger.addAppender((Appender)chainsaw);
                }
            }
            catch (IOException e) {
                throw new InitialisationException(new Message(58, "Log4j configuration"), e, this);
            }
        }
    }

    protected void logEvent(UMOServerNotification e) {
        if (this.eventLogger != null) {
            String actionKey = e.EVENT_NAME + "." + e.getActionName();
            String level = MapUtils.getString((Map)this.levelMappings, (Object)actionKey, (String)e.getType());
            this.eventLogger.log((Priority)Level.toLevel((String)level, (Level)Level.INFO), (Object)e);
        }
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public String getLogConfigFile() {
        return this.logConfigFile;
    }

    public void setLogConfigFile(String logConfigFile) {
        this.logConfigFile = logConfigFile;
    }

    public String getChainsawHost() {
        return this.chainsawHost;
    }

    public void setChainsawHost(String chainsawHost) {
        this.chainsawHost = chainsawHost;
    }

    public int getChainsawPort() {
        return this.chainsawPort;
    }

    public void setChainsawPort(int chainsawPort) {
        this.chainsawPort = chainsawPort;
    }

    public Map getLevelMappings() {
        return this.levelMappings;
    }

    public void setLevelMappings(Map levelMappings) {
        this.levelMappings.putAll(levelMappings);
    }
}

