/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.container;

import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.mule.MuleManager;
import org.mule.impl.container.AbstractContainerContext;
import org.mule.umo.manager.ContainerException;
import org.mule.umo.manager.ObjectNotFoundException;
import org.mule.util.TemplateParser;

public class PropertiesContainerContext
extends AbstractContainerContext {
    protected Map systemProperties;
    protected Map properties;
    protected boolean loadSystemProperties = true;
    protected boolean enableTemplates = false;
    protected TemplateParser templateParser = TemplateParser.createAntStyleParser();

    public PropertiesContainerContext() {
        super("properties");
    }

    public void configure(Reader configuration) throws ContainerException {
        throw new UnsupportedOperationException("configure");
    }

    public Object getComponent(Object key) throws ObjectNotFoundException {
        if (key == null) {
            throw new ObjectNotFoundException("null");
        }
        Object value = MuleManager.getInstance().getProperty(key.toString());
        if (value == null) {
            throw new ObjectNotFoundException(key.toString());
        }
        if (value instanceof String && this.enableTemplates) {
            value = this.templateParser.parse(MuleManager.getInstance().getProperties(), value.toString());
        }
        return value;
    }

    public Map getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Map properties) {
        String value;
        Map.Entry entry;
        this.systemProperties = properties;
        if (this.systemProperties != null) {
            Iterator iterator = this.systemProperties.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                value = entry.getValue().toString();
                value = this.templateParser.parse(this.systemProperties, value.toString());
                value = this.templateParser.parse(MuleManager.getInstance().getProperties(), value.toString());
                System.setProperty(entry.getKey().toString(), value);
            }
        }
        if (this.loadSystemProperties) {
            Properties props = System.getProperties();
            Iterator iterator = props.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                value = entry.getValue().toString();
                value = this.templateParser.parse(MuleManager.getInstance().getProperties(), value.toString());
                MuleManager.getInstance().setProperty(entry.getKey(), value);
            }
        }
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
        if (properties != null) {
            Iterator iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String value = entry.getValue().toString();
                value = this.templateParser.parse(MuleManager.getInstance().getProperties(), value.toString());
                MuleManager.getInstance().setProperty(entry.getKey(), value);
            }
        }
    }
}

