/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.providers.AbstractServiceEnabledConnector;
import org.mule.providers.service.ConnectorFactoryException;
import org.mule.providers.service.ConnectorServiceDescriptor;
import org.mule.providers.service.ConnectorServiceException;
import org.mule.providers.service.ConnectorServiceFinder;
import org.mule.providers.service.ConnectorServiceNotFoundException;
import org.mule.umo.endpoint.EndpointException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;
import org.mule.util.MuleObjectHelper;
import org.mule.util.ObjectFactory;
import org.mule.util.ObjectNameHelper;
import org.mule.util.PropertiesUtils;
import org.mule.util.SpiUtils;

public class ConnectorFactory {
    public static final String PROVIDER_SERVICES_PATH = "org/mule/providers";
    protected static Log logger = LogFactory.getLog((Class)ConnectorFactory.class);
    public static final int GET_OR_CREATE_CONNECTOR = 0;
    public static final int ALWAYS_CREATE_CONNECTOR = 1;
    public static final int NEVER_CREATE_CONNECTOR = 2;
    public static final int USE_CONNECTOR = 3;
    private static Map csdCache = new HashMap();

    public static UMOEndpoint createEndpoint(UMOEndpointURI uri, String type) throws EndpointException {
        String scheme = uri.getFullScheme();
        UMOConnector connector = null;
        try {
            if (uri.getCreateConnector() == 1) {
                connector = ConnectorFactory.createConnector(uri);
                MuleManager.getInstance().registerConnector(connector);
            } else if (uri.getCreateConnector() == 2) {
                connector = ConnectorFactory.getConnectorByProtocol(scheme);
            } else if (uri.getConnectorName() != null) {
                connector = MuleManager.getInstance().lookupConnector(uri.getConnectorName());
                if (connector == null) {
                    throw new ConnectorFactoryException(new Message(82, "Connector: " + uri.getConnectorName()));
                }
            } else {
                connector = ConnectorFactory.getConnectorByProtocol(scheme);
                if (connector == null) {
                    connector = ConnectorFactory.createConnector(uri);
                    MuleManager.getInstance().registerConnector(connector);
                }
            }
        }
        catch (Exception e) {
            throw new ConnectorFactoryException(e);
        }
        if (connector == null) {
            Message m = new Message(74, "Endpoint", (Object)("Uri: " + uri));
            m.setNextMessage(new Message(45, "connector"));
            throw new ConnectorFactoryException(m);
        }
        MuleEndpoint endpoint = new MuleEndpoint();
        endpoint.setConnector(connector);
        endpoint.setEndpointURI(uri);
        if (uri.getEndpointName() != null) {
            endpoint.setName(uri.getEndpointName());
        }
        String name = ObjectNameHelper.getEndpointName(endpoint);
        endpoint.setName(name);
        if (type != null) {
            endpoint.setType(type);
            UMOTransformer trans = ConnectorFactory.getTransformer(uri, connector, "receiver".equals(type) ? 0 : 1);
            endpoint.setTransformer(trans);
            if ("receiver".equals(type)) {
                trans = ConnectorFactory.getTransformer(uri, connector, 2);
                endpoint.setResponseTransformer(trans);
            }
        }
        return endpoint;
    }

    private static UMOTransformer getTransformer(UMOEndpointURI url, UMOConnector cnn, int type) throws ConnectorFactoryException {
        UMOTransformer trans = null;
        String transId = null;
        transId = type == 2 ? url.getResponseTransformers() : url.getTransformers();
        if (transId != null) {
            try {
                trans = MuleObjectHelper.getTransformer(transId, ",");
            }
            catch (MuleException e) {
                throw new ConnectorFactoryException(e);
            }
        } else {
            Map so;
            Properties overrides = new Properties();
            if (cnn instanceof AbstractServiceEnabledConnector && (so = ((AbstractServiceEnabledConnector)cnn).getServiceOverrides()) != null) {
                overrides.putAll((Map<?, ?>)so);
            }
            String scheme = url.getSchemeMetaInfo();
            ConnectorServiceDescriptor csd = ConnectorFactory.getServiceDescriptor(scheme, overrides);
            trans = type == 0 ? csd.createInboundTransformer() : (type == 1 ? csd.createOutboundTransformer() : csd.createResponseTransformer());
        }
        return trans;
    }

    public static UMOConnector createConnector(UMOEndpointURI url) throws ConnectorFactoryException {
        UMOConnector connector;
        block9: {
            String scheme = url.getSchemeMetaInfo();
            connector = null;
            ConnectorServiceDescriptor csd = ConnectorFactory.getServiceDescriptor(scheme);
            if (csd.getServiceError() != null) {
                throw new ConnectorServiceException(Message.createStaticMessage(csd.getServiceError()));
            }
            if (csd.getServiceFinder() != null) {
                csd = csd.createServiceFinder().findService(scheme, csd);
            }
            try {
                if (csd.getConnectorFactory() != null) {
                    ObjectFactory factory = (ObjectFactory)ClassUtils.loadClass(csd.getConnectorFactory(), ConnectorFactory.class).newInstance();
                    connector = (UMOConnector)factory.create();
                    break block9;
                }
                if (csd.getConnector() != null) {
                    connector = (UMOConnector)ClassUtils.loadClass(csd.getConnector(), ConnectorFactory.class).newInstance();
                    if (connector instanceof AbstractServiceEnabledConnector) {
                        ((AbstractServiceEnabledConnector)connector).initialiseFromUrl(url);
                    }
                    break block9;
                }
                throw new ConnectorFactoryException(new Message(75, "Connector", (Object)scheme));
            }
            catch (ConnectorFactoryException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConnectorFactoryException(new Message(74, "Endpoint", (Object)url), (Throwable)e);
            }
        }
        connector.setName(ObjectNameHelper.getConnectorName(connector));
        Map props = new HashMap();
        PropertiesUtils.getPropertiesWithPrefix(MuleManager.getInstance().getProperties(), connector.getProtocol().toLowerCase(), props);
        if (props.size() > 0) {
            props = PropertiesUtils.removeNamespaces(props);
            BeanUtils.populateWithoutFail(connector, props, true);
        }
        return connector;
    }

    public static ConnectorServiceDescriptor getServiceDescriptor(String protocol) throws ConnectorFactoryException {
        return ConnectorFactory.getServiceDescriptor(protocol, null);
    }

    public static ConnectorServiceDescriptor getServiceDescriptor(String protocol, Properties overrides) throws ConnectorFactoryException {
        ConnectorServiceDescriptor csd = (ConnectorServiceDescriptor)csdCache.get(new CSDKey(protocol, overrides));
        if (csd == null) {
            String location = "META-INF/services/org/mule/providers";
            InputStream is = SpiUtils.findServiceDescriptor(PROVIDER_SERVICES_PATH, protocol + ".properties", ConnectorFactory.class);
            if (is == null && (is = SpiUtils.findServiceDescriptor(PROVIDER_SERVICES_PATH, protocol, ConnectorFactory.class)) == null) {
                logger.warn((Object)("The transport " + protocol + " is using a legacy style of descriptor. This needs to be updated." + " Future versions of Mule will not work with this connector descriptor."));
            }
            try {
                if (is != null) {
                    Properties props = new Properties();
                    props.load(is);
                    csd = new ConnectorServiceDescriptor(protocol, location, props);
                    csd.setOverrides(overrides);
                    if (csd.getServiceFinder() != null) {
                        ConnectorServiceFinder finder = csd.createServiceFinder();
                        csd = finder.findService(protocol, csd);
                    }
                } else {
                    throw new ConnectorServiceNotFoundException(location + "/" + protocol);
                }
                csdCache.put(new CSDKey(csd.getProtocol(), overrides), csd);
            }
            catch (IOException e) {
                throw new ConnectorFactoryException(new Message(87, location + "/" + protocol), (Throwable)e);
            }
        }
        return csd;
    }

    public static UMOConnector getOrCreateConnectorByProtocol(UMOEndpointURI uri) throws ConnectorFactoryException {
        return ConnectorFactory.getOrCreateConnectorByProtocol(uri, uri.getCreateConnector());
    }

    public static UMOConnector getOrCreateConnectorByProtocol(UMOImmutableEndpoint endpoint) throws ConnectorFactoryException {
        return ConnectorFactory.getOrCreateConnectorByProtocol(endpoint.getEndpointURI(), endpoint.getCreateConnector());
    }

    private static UMOConnector getOrCreateConnectorByProtocol(UMOEndpointURI uri, int create) throws ConnectorFactoryException {
        UMOConnector connector = ConnectorFactory.getConnectorByProtocol(uri.getFullScheme());
        if (1 == create || connector == null && create == 0) {
            connector = ConnectorFactory.createConnector(uri);
            try {
                BeanUtils.populate((Object)connector, (Map)uri.getParams());
                MuleManager.getInstance().registerConnector(connector);
            }
            catch (Exception e) {
                throw new ConnectorFactoryException(new Message(83, "Connector"), (Throwable)e);
            }
        } else if (create == 2 && connector == null) {
            logger.warn((Object)("There is no connector for protocol: " + uri.getScheme() + " and 'createConnector' is set to NEVER.  Returning null"));
        }
        return connector;
    }

    public static UMOConnector getConnectorByProtocol(String protocol) {
        Map connectors = MuleManager.getInstance().getConnectors();
        Iterator iterator = connectors.values().iterator();
        while (iterator.hasNext()) {
            UMOConnector connector = (UMOConnector)iterator.next();
            if (!connector.supportsProtocol(protocol)) continue;
            return connector;
        }
        return null;
    }

    private static class CSDKey {
        private Map overrides;
        private String protocol;

        public CSDKey(String protocol, Map overrides) {
            this.overrides = overrides;
            this.protocol = protocol;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CSDKey)) {
                return false;
            }
            CSDKey csdKey = (CSDKey)o;
            if (this.overrides != null ? !((Object)this.overrides).equals(csdKey.overrides) : csdKey.overrides != null) {
                return false;
            }
            return this.protocol.equals(csdKey.protocol);
        }

        public int hashCode() {
            int result = this.overrides != null ? ((Object)this.overrides).hashCode() : 0;
            result = 29 * result + this.protocol.hashCode();
            return result;
        }
    }
}

