/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntryPoint {
    protected static Log logger = LogFactory.getLog((Class)EntryPoint.class);
    private Method method;

    public EntryPoint(Method method) {
        this.method = method;
    }

    public Object invoke(Object component, Object arg) throws InvocationTargetException, IllegalAccessException {
        String methodCall = null;
        if (logger.isDebugEnabled()) {
            methodCall = component.getClass().getName() + "." + this.method.getName() + "(" + arg.getClass().getName() + ")";
            logger.debug((Object)("Invoking " + methodCall));
        }
        Object result = this.method.invoke(component, arg);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Result of call " + methodCall + " is " + result));
        }
        return result;
    }

    public boolean isVoid() {
        return this.method.getReturnType().getName().equals("void");
    }

    public String getName() {
        if (this.method == null) {
            return null;
        }
        return this.method.getName();
    }

    public Class getParameterType() {
        return this.method.getParameterTypes()[0];
    }

    public Class getReturnType() {
        if (this.isVoid()) {
            return null;
        }
        return this.method.getReturnType();
    }

    protected void setMethod(Method method) {
        this.method = method;
    }

    protected Method getMethod() {
        return this.method;
    }
}

