/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.work;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.mule.config.ThreadingProfile;
import org.mule.impl.work.NullWorkExecutorPool;
import org.mule.impl.work.WorkExecutorPool;
import org.mule.util.concurrent.WaitPolicy;

public class WorkExecutorPoolImpl
implements WorkExecutorPool {
    private ThreadPoolExecutor pooledExecutor;
    private ThreadingProfile profile;
    private String name;
    private static final long SHUTDOWN_TIMEOUT = 5000L;

    public WorkExecutorPoolImpl(ThreadingProfile profile, String name) {
        this.profile = profile;
        this.name = name;
        this.pooledExecutor = profile.createPool(name);
    }

    public WorkExecutorPoolImpl(BlockingQueue queue, int maxSize) {
        this.pooledExecutor = new ThreadPoolExecutor(0, maxSize, 60L, TimeUnit.SECONDS, queue);
        this.pooledExecutor.setCorePoolSize(maxSize);
        this.pooledExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new WaitPolicy(30000L, TimeUnit.MILLISECONDS));
    }

    public void execute(Runnable work) {
        this.pooledExecutor.execute(work);
    }

    public int getPoolSize() {
        return this.pooledExecutor.getPoolSize();
    }

    public int getMaximumPoolSize() {
        return this.pooledExecutor.getMaximumPoolSize();
    }

    public void setMaximumPoolSize(int maxSize) {
        this.pooledExecutor.setMaximumPoolSize(maxSize);
    }

    public WorkExecutorPool start() {
        throw new IllegalStateException("This pooled executor is already started");
    }

    public WorkExecutorPool stop() {
        this.pooledExecutor.shutdownNow();
        try {
            this.pooledExecutor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return new NullWorkExecutorPool(this.profile, this.name);
    }
}

