/*
 * $Id: Delta.java 3798 2006-11-04 04:07:14Z aperepel $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the MuleSource MPL
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.util.counters.impl;

import org.mule.util.counters.CounterFactory.Type;

/**
 * @author <a href="mailto:gnt@codehaus.org">Guillaume Nodet</a>
 * @version $Revision: 3798 $
 */
public class Delta extends AggregateCounter
{

    private double first = 0.0;
    private double second = 0.0;

    public Delta(String name, AbstractCounter base)
    {
        super(name, Type.DELTA, base);
    }

    public double nextValue()
    {
        if (first == Double.NaN || second == Double.NaN)
        {
            return Double.NaN;
        }
        else
        {
            return second - first > 0.0 ? second - first : 0.0;
        }
    }

    public void doCompute()
    {
        first = second;
        second = getBase().nextValue();
    }

}
