/*
 * $Id: UnsupportedAuthenticationSchemeException.java 3798 2006-11-04 04:07:14Z aperepel $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the MuleSource MPL
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.umo.security;

import org.mule.config.i18n.Message;
import org.mule.umo.UMOMessage;

/**
 * <code>UnsupportedAuthenticationSchemeException</code> is thrown when a
 * authentication scheme is being used on the message that the Security filter does
 * not understand
 * 
 * @author <a href="mailto:ross.mason@symphonysoft.com">Ross Mason</a>
 * @version $Revision: 3798 $
 */
public class UnsupportedAuthenticationSchemeException extends SecurityException
{
    /**
     * Serial version
     */
    private static final long serialVersionUID = 3281021140543598680L;

    public UnsupportedAuthenticationSchemeException(Message message, UMOMessage umoMessage)
    {
        super(message, umoMessage);
    }

    public UnsupportedAuthenticationSchemeException(Message message, UMOMessage umoMessage, Throwable cause)
    {
        super(message, umoMessage, cause);
    }
}
