/*
 * $Id: SgmlEntityEncoder.java 3798 2006-11-04 04:07:14Z aperepel $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the MuleSource MPL
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transformers.codec;

import org.mule.transformers.AbstractTransformer;
import org.mule.umo.transformer.TransformerException;
import org.mule.util.SgmlCodec;

import java.io.UnsupportedEncodingException;

/**
 * Encodes a string with SGML entities
 * 
 * @author <a href="mailto:ross.mason@symphonysoft.com">Ross Mason</a>
 * @version $Revision: 3798 $
 */
public class SgmlEntityEncoder extends AbstractTransformer
{
    /**
     * Serial version
     */
    private static final long serialVersionUID = 4229616539951956886L;

    public SgmlEntityEncoder()
    {
        registerSourceType(String.class);
        registerSourceType(byte[].class);
        setReturnClass(String.class);
    }

    public Object doTransform(Object src, String encoding) throws TransformerException
    {
        if (src instanceof byte[])
        {
            if (encoding != null)
            {
                try
                {
                    return SgmlCodec.encodeString(new String((byte[])src, encoding));
                }
                catch (UnsupportedEncodingException ex)
                {
                    return SgmlCodec.encodeString(new String((byte[])src));
                }
            }
            else
            {
                return SgmlCodec.encodeString(new String((byte[])src));
            }
        }
        else
        {
            return SgmlCodec.encodeString(src.toString());
        }
    }
}
