/*
 * $Id: CallableEntryPointResolver.java 3798 2006-11-04 04:07:14Z aperepel $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the MuleSource MPL
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.model;

import org.mule.umo.model.UMOEntryPointResolver;
import org.mule.umo.model.UMOEntryPoint;
import org.mule.umo.model.ModelException;
import org.mule.umo.UMODescriptor;

/**
 * An entrypoint resolver that only allows Service objects that implmement the
 * Callable interface
 * 
 * @see org.mule.umo.lifecycle.Callable
 * @author <a href="mailto:ross.mason@symphonysoft.com">Ross Mason</a>
 * @version $Revision: 3798 $
 */
public class CallableEntryPointResolver implements UMOEntryPointResolver
{
    public UMOEntryPoint resolveEntryPoint(UMODescriptor componentDescriptor) throws ModelException
    {
        return new CallableEntryPoint();
    }
}
