/*
 * $Id: MuleHeaderCredentialsAccessor.java 3798 2006-11-04 04:07:14Z aperepel $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the MuleSource MPL
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.impl.security;

import org.mule.config.MuleProperties;
import org.mule.umo.UMOEvent;
import org.mule.umo.security.UMOCredentialsAccessor;

/**
 * <code>MuleHeaderCredentialsAccessor</code> obtains and sets the user credentials
 * as Mule property headers
 * 
 * @author <a href="mailto:ross.mason@symphonysoft.com">Ross Mason</a>
 * @version $Revision: 3798 $
 */
public class MuleHeaderCredentialsAccessor implements UMOCredentialsAccessor
{
    public Object getCredentials(UMOEvent event)
    {
        return event.getMessage().getProperty(MuleProperties.MULE_USER_PROPERTY);
    }

    public void setCredentials(UMOEvent event, Object credentials)
    {
        event.getMessage().setProperty(MuleProperties.MULE_USER_PROPERTY, credentials);
    }
}
