/*
 * $Id: CommonsPoolFactory.java 3798 2006-11-04 04:07:14Z aperepel $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the MuleSource MPL
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.config.pool;

import org.mule.impl.MuleDescriptor;
import org.mule.umo.UMODescriptor;
import org.mule.umo.model.UMOPoolFactory;
import org.mule.util.ObjectFactory;
import org.mule.util.ObjectPool;

/**
 * <code>CommonsPoolFactory</code> is a commons-pool pool implementation for mule.
 * this is the default implementation used if no other is configured.
 * 
 * @author <a href="mailto:ross.mason@symphonysoft.com">Ross Mason</a>
 * @version $Revision: 3798 $
 */
public class CommonsPoolFactory implements UMOPoolFactory
{
    public ObjectPool createPool(UMODescriptor descriptor, ObjectFactory factory)
    {
        return new CommonsPoolProxyPool((MuleDescriptor)descriptor, factory);
    }

    public ObjectPool createPool(UMODescriptor descriptor)
    {
        return new CommonsPoolProxyPool((MuleDescriptor)descriptor, new CommonsPoolProxyFactory(
            (MuleDescriptor)descriptor));
    }
}
