/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SgmlCodec {
    private static final Map decoder = new HashMap(300);
    private static final String[] encoder = new String[256];
    private static final Pattern entityPattern = Pattern.compile("&#(\\d+);|&(\\w+);");

    public static final String encodeString(String s) {
        int length = s.length();
        StringBuffer buffer = new StringBuffer(length * 2);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            char j = c;
            if (j < '\u0100' && encoder[j] != null) {
                buffer.append(encoder[j]);
                buffer.append(';');
                continue;
            }
            if (j < '\u0080') {
                buffer.append(c);
                continue;
            }
            buffer.append("&#");
            buffer.append((int)c);
            buffer.append(';');
        }
        return buffer.toString();
    }

    public static final String decodeString(String string) {
        String result = string;
        Matcher m = entityPattern.matcher(string);
        while (m.find()) {
            String ent = m.group();
            result = result.replaceAll(ent, SgmlCodec.decodeEntity(ent));
        }
        return result;
    }

    public static final String decodeEntity(String entity) {
        if (entity.charAt(entity.length() - 1) == ';') {
            entity = entity.substring(0, entity.length() - 1);
        }
        if (entity.charAt(1) == '#') {
            int start = 2;
            int radix = 10;
            if (entity.charAt(2) == 'X' || entity.charAt(2) == 'x') {
                ++start;
                radix = 16;
            }
            return String.valueOf((char)Integer.parseInt(entity.substring(start), radix));
        }
        String s = (String)decoder.get(entity);
        if (s != null) {
            return s;
        }
        return "";
    }

    protected static final void add(String entity, int value) {
        decoder.put(entity, String.valueOf((char)value));
        if (value < 256) {
            SgmlCodec.encoder[value] = entity;
        }
    }

    static {
        SgmlCodec.add("&quot", 34);
        SgmlCodec.add("&amp", 38);
        SgmlCodec.add("&lt", 60);
        SgmlCodec.add("&gt", 62);
        SgmlCodec.add("&at", 64);
        SgmlCodec.add("&nbsp", 160);
        SgmlCodec.add("&iexcl", 161);
        SgmlCodec.add("&cent", 162);
        SgmlCodec.add("&pound", 163);
        SgmlCodec.add("&curren", 164);
        SgmlCodec.add("&yen", 165);
        SgmlCodec.add("&brvbar", 166);
        SgmlCodec.add("&sect", 167);
        SgmlCodec.add("&uml", 168);
        SgmlCodec.add("&copy", 169);
        SgmlCodec.add("&ordf", 170);
        SgmlCodec.add("&laquo", 171);
        SgmlCodec.add("&not", 172);
        SgmlCodec.add("&shy", 173);
        SgmlCodec.add("&reg", 174);
        SgmlCodec.add("&macr", 175);
        SgmlCodec.add("&deg", 176);
        SgmlCodec.add("&plusmn", 177);
        SgmlCodec.add("&sup2", 178);
        SgmlCodec.add("&sup3", 179);
        SgmlCodec.add("&acute", 180);
        SgmlCodec.add("&micro", 181);
        SgmlCodec.add("&para", 182);
        SgmlCodec.add("&middot", 183);
        SgmlCodec.add("&cedil", 184);
        SgmlCodec.add("&sup1", 185);
        SgmlCodec.add("&ordm", 186);
        SgmlCodec.add("&raquo", 187);
        SgmlCodec.add("&frac14", 188);
        SgmlCodec.add("&frac12", 189);
        SgmlCodec.add("&frac34", 190);
        SgmlCodec.add("&iquest", 191);
        SgmlCodec.add("&Agrave", 192);
        SgmlCodec.add("&Aacute", 193);
        SgmlCodec.add("&Acirc", 194);
        SgmlCodec.add("&Atilde", 195);
        SgmlCodec.add("&Auml", 196);
        SgmlCodec.add("&Aring", 197);
        SgmlCodec.add("&AElig", 198);
        SgmlCodec.add("&Ccedil", 199);
        SgmlCodec.add("&Egrave", 200);
        SgmlCodec.add("&Eacute", 201);
        SgmlCodec.add("&Ecirc", 202);
        SgmlCodec.add("&Euml", 203);
        SgmlCodec.add("&Igrave", 204);
        SgmlCodec.add("&Iacute", 205);
        SgmlCodec.add("&Icirc", 206);
        SgmlCodec.add("&Iuml", 207);
        SgmlCodec.add("&ETH", 208);
        SgmlCodec.add("&Ntilde", 209);
        SgmlCodec.add("&Ograve", 210);
        SgmlCodec.add("&Oacute", 211);
        SgmlCodec.add("&Ocirc", 212);
        SgmlCodec.add("&Otilde", 213);
        SgmlCodec.add("&Ouml", 214);
        SgmlCodec.add("&times", 215);
        SgmlCodec.add("&Oslash", 216);
        SgmlCodec.add("&Ugrave", 217);
        SgmlCodec.add("&Uacute", 218);
        SgmlCodec.add("&Ucirc", 219);
        SgmlCodec.add("&Uuml", 220);
        SgmlCodec.add("&Yacute", 221);
        SgmlCodec.add("&THORN", 222);
        SgmlCodec.add("&szlig", 223);
        SgmlCodec.add("&agrave", 224);
        SgmlCodec.add("&aacute", 225);
        SgmlCodec.add("&acirc", 226);
        SgmlCodec.add("&atilde", 227);
        SgmlCodec.add("&auml", 228);
        SgmlCodec.add("&aring", 229);
        SgmlCodec.add("&aelig", 230);
        SgmlCodec.add("&ccedil", 231);
        SgmlCodec.add("&egrave", 232);
        SgmlCodec.add("&eacute", 233);
        SgmlCodec.add("&ecirc", 234);
        SgmlCodec.add("&euml", 235);
        SgmlCodec.add("&igrave", 236);
        SgmlCodec.add("&iacute", 237);
        SgmlCodec.add("&icirc", 238);
        SgmlCodec.add("&iuml", 239);
        SgmlCodec.add("&eth", 240);
        SgmlCodec.add("&ntilde", 241);
        SgmlCodec.add("&ograve", 242);
        SgmlCodec.add("&oacute", 243);
        SgmlCodec.add("&ocirc", 244);
        SgmlCodec.add("&otilde", 245);
        SgmlCodec.add("&ouml", 246);
        SgmlCodec.add("&divide", 247);
        SgmlCodec.add("&oslash", 248);
        SgmlCodec.add("&ugrave", 249);
        SgmlCodec.add("&uacute", 250);
        SgmlCodec.add("&ucirc", 251);
        SgmlCodec.add("&uuml", 252);
        SgmlCodec.add("&yacute", 253);
        SgmlCodec.add("&thorn", 254);
        SgmlCodec.add("&yuml", 255);
        SgmlCodec.add("&fnof", 402);
        SgmlCodec.add("&Alpha", 913);
        SgmlCodec.add("&Beta", 914);
        SgmlCodec.add("&Gamma", 915);
        SgmlCodec.add("&Delta", 916);
        SgmlCodec.add("&Epsilon", 917);
        SgmlCodec.add("&Zeta", 918);
        SgmlCodec.add("&Eta", 919);
        SgmlCodec.add("&Theta", 920);
        SgmlCodec.add("&Iota", 921);
        SgmlCodec.add("&Kappa", 922);
        SgmlCodec.add("&Lambda", 923);
        SgmlCodec.add("&Mu", 924);
        SgmlCodec.add("&Nu", 925);
        SgmlCodec.add("&Xi", 926);
        SgmlCodec.add("&Omicron", 927);
        SgmlCodec.add("&Pi", 928);
        SgmlCodec.add("&Rho", 929);
        SgmlCodec.add("&Sigma", 931);
        SgmlCodec.add("&Tau", 932);
        SgmlCodec.add("&Upsilon", 933);
        SgmlCodec.add("&Phi", 934);
        SgmlCodec.add("&Chi", 935);
        SgmlCodec.add("&Psi", 936);
        SgmlCodec.add("&Omega", 937);
        SgmlCodec.add("&alpha", 945);
        SgmlCodec.add("&beta", 946);
        SgmlCodec.add("&gamma", 947);
        SgmlCodec.add("&delta", 948);
        SgmlCodec.add("&epsilon", 949);
        SgmlCodec.add("&zeta", 950);
        SgmlCodec.add("&eta", 951);
        SgmlCodec.add("&theta", 952);
        SgmlCodec.add("&iota", 953);
        SgmlCodec.add("&kappa", 954);
        SgmlCodec.add("&lambda", 955);
        SgmlCodec.add("&mu", 956);
        SgmlCodec.add("&nu", 957);
        SgmlCodec.add("&xi", 958);
        SgmlCodec.add("&omicron", 959);
        SgmlCodec.add("&pi", 960);
        SgmlCodec.add("&rho", 961);
        SgmlCodec.add("&sigmaf", 962);
        SgmlCodec.add("&sigma", 963);
        SgmlCodec.add("&tau", 964);
        SgmlCodec.add("&upsilon", 965);
        SgmlCodec.add("&phi", 966);
        SgmlCodec.add("&chi", 967);
        SgmlCodec.add("&psi", 968);
        SgmlCodec.add("&omega", 969);
        SgmlCodec.add("&thetasym", 977);
        SgmlCodec.add("&upsih", 978);
        SgmlCodec.add("&piv", 982);
        SgmlCodec.add("&bull", 8226);
        SgmlCodec.add("&hellip", 8230);
        SgmlCodec.add("&prime", 8242);
        SgmlCodec.add("&Prime", 8243);
        SgmlCodec.add("&oline", 8254);
        SgmlCodec.add("&frasl", 8260);
        SgmlCodec.add("&weierp", 8472);
        SgmlCodec.add("&image", 8465);
        SgmlCodec.add("&real", 8476);
        SgmlCodec.add("&trade", 8482);
        SgmlCodec.add("&alefsym", 8501);
        SgmlCodec.add("&larr", 8592);
        SgmlCodec.add("&uarr", 8593);
        SgmlCodec.add("&rarr", 8594);
        SgmlCodec.add("&darr", 8595);
        SgmlCodec.add("&harr", 8596);
        SgmlCodec.add("&crarr", 8629);
        SgmlCodec.add("&lArr", 8656);
        SgmlCodec.add("&uArr", 8657);
        SgmlCodec.add("&rArr", 8658);
        SgmlCodec.add("&dArr", 8659);
        SgmlCodec.add("&hArr", 8660);
        SgmlCodec.add("&forall", 8704);
        SgmlCodec.add("&part", 8706);
        SgmlCodec.add("&exist", 8707);
        SgmlCodec.add("&empty", 8709);
        SgmlCodec.add("&nabla", 8711);
        SgmlCodec.add("&isin", 8712);
        SgmlCodec.add("&notin", 8713);
        SgmlCodec.add("&ni", 8715);
        SgmlCodec.add("&prod", 8719);
        SgmlCodec.add("&sum", 8721);
        SgmlCodec.add("&minus", 8722);
        SgmlCodec.add("&lowast", 8727);
        SgmlCodec.add("&radic", 8730);
        SgmlCodec.add("&prop", 8733);
        SgmlCodec.add("&infin", 8734);
        SgmlCodec.add("&ang", 8736);
        SgmlCodec.add("&and", 8743);
        SgmlCodec.add("&or", 8744);
        SgmlCodec.add("&cap", 8745);
        SgmlCodec.add("&cup", 8746);
        SgmlCodec.add("&int", 8747);
        SgmlCodec.add("&there4", 8756);
        SgmlCodec.add("&sim", 8764);
        SgmlCodec.add("&cong", 8773);
        SgmlCodec.add("&asymp", 8776);
        SgmlCodec.add("&ne", 8800);
        SgmlCodec.add("&equiv", 8801);
        SgmlCodec.add("&le", 8804);
        SgmlCodec.add("&ge", 8805);
        SgmlCodec.add("&sub", 8834);
        SgmlCodec.add("&sup", 8835);
        SgmlCodec.add("&nsub", 8836);
        SgmlCodec.add("&sube", 8838);
        SgmlCodec.add("&supe", 8839);
        SgmlCodec.add("&oplus", 8853);
        SgmlCodec.add("&otimes", 8855);
        SgmlCodec.add("&perp", 8869);
        SgmlCodec.add("&sdot", 8901);
        SgmlCodec.add("&lceil", 8968);
        SgmlCodec.add("&rceil", 8969);
        SgmlCodec.add("&lfloor", 8970);
        SgmlCodec.add("&rfloor", 8971);
        SgmlCodec.add("&lang", 9001);
        SgmlCodec.add("&rang", 9002);
        SgmlCodec.add("&loz", 9674);
        SgmlCodec.add("&spades", 9824);
        SgmlCodec.add("&clubs", 9827);
        SgmlCodec.add("&hearts", 9829);
        SgmlCodec.add("&diams", 9830);
        SgmlCodec.add("&OElig", 338);
        SgmlCodec.add("&oelig", 339);
        SgmlCodec.add("&Scaron", 352);
        SgmlCodec.add("&scaron", 353);
        SgmlCodec.add("&Yuml", 376);
        SgmlCodec.add("&circ", 710);
        SgmlCodec.add("&tilde", 732);
        SgmlCodec.add("&ensp", 8194);
        SgmlCodec.add("&emsp", 8195);
        SgmlCodec.add("&thinsp", 8201);
        SgmlCodec.add("&zwnj", 8204);
        SgmlCodec.add("&zwj", 8205);
        SgmlCodec.add("&lrm", 8206);
        SgmlCodec.add("&rlm", 8207);
        SgmlCodec.add("&ndash", 8211);
        SgmlCodec.add("&mdash", 8212);
        SgmlCodec.add("&lsquo", 8216);
        SgmlCodec.add("&rsquo", 8217);
        SgmlCodec.add("&sbquo", 8218);
        SgmlCodec.add("&ldquo", 8220);
        SgmlCodec.add("&rdquo", 8221);
        SgmlCodec.add("&bdquo", 8222);
        SgmlCodec.add("&dagger", 8224);
        SgmlCodec.add("&Dagger", 8225);
        SgmlCodec.add("&permil", 8240);
        SgmlCodec.add("&lsaquo", 8249);
        SgmlCodec.add("&rsaquo", 8250);
        SgmlCodec.add("&euro", 8364);
    }
}

