/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.SystemUtils;
import org.mule.config.i18n.Message;
import org.mule.umo.UMOMessage;
import org.mule.util.IOUtils;

public class PropertiesUtils {
    private static final List maskedProperties = new CopyOnWriteArrayList();

    public static void registeredMaskedPropertyName(String name) {
        if (name != null) {
            maskedProperties.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Properties loadProperties(String fileName, Class callingClass) throws IOException {
        InputStream is = IOUtils.getResourceAsStream(fileName, callingClass, true, false);
        if (is == null) {
            Message error = new Message(122, fileName);
            throw new IOException(error.toString());
        }
        try {
            Properties props = new Properties();
            props.load(is);
            Properties properties = props;
            return properties;
        }
        finally {
            is.close();
        }
    }

    public static String removeXmlNamespacePrefix(String eleName) {
        int i = eleName.indexOf(58);
        return eleName.substring(i + 1, eleName.length());
    }

    public static String removeNamespacePrefix(String eleName) {
        int i = eleName.lastIndexOf(46);
        return eleName.substring(i + 1, eleName.length());
    }

    public static Map removeNamespaces(Map properties) {
        HashMap props = new HashMap(properties.size());
        Iterator iter = properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            props.put(PropertiesUtils.removeNamespacePrefix((String)entry.getKey()), entry.getValue());
        }
        return props;
    }

    public static Map getPropertiesWithPrefix(Map props, String prefix) {
        HashMap newProps = new HashMap();
        Iterator iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!entry.getKey().toString().startsWith(prefix)) continue;
            newProps.put(entry.getKey(), entry.getValue());
        }
        return newProps;
    }

    public static void getPropertiesWithPrefix(Map props, String prefix, Map newProps) {
        Iterator iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!entry.getKey().toString().startsWith(prefix)) continue;
            newProps.put(entry.getKey(), entry.getValue());
        }
    }

    public static Map getPropertiesWithoutPrefix(Map props, String prefix) {
        HashMap newProps = new HashMap();
        Iterator iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getKey().toString().startsWith(prefix)) continue;
            newProps.put(entry.getKey(), entry.getValue());
        }
        return newProps;
    }

    public static Properties getPropertiesFromQueryString(String query) {
        Properties props = new Properties();
        if (query == null) {
            return props;
        }
        query = new StringBuffer(query.length() + 1).append('&').append(query).toString();
        int x = 0;
        while ((x = PropertiesUtils.addProperty(query, x, props)) != -1) {
        }
        return props;
    }

    /*
     * WARNING - void declaration
     */
    private static int addProperty(String query, int start, Properties properties) {
        void var5_5;
        String pair;
        int i = query.indexOf(38, start);
        int i2 = query.indexOf(38, i + 1);
        if (i > -1 && i2 > -1) {
            pair = query.substring(i + 1, i2);
        } else if (i > -1) {
            pair = query.substring(i + 1);
        } else {
            return -1;
        }
        int eq = var5_5.indexOf(61);
        if (eq <= 0) {
            void key = var5_5;
            String value = "";
            properties.setProperty((String)key, value);
        } else {
            String key = var5_5.substring(0, eq);
            String value = eq == var5_5.length() ? "" : var5_5.substring(eq + 1);
            properties.setProperty(key, value);
        }
        return i2;
    }

    public static String propertiesToString(Map props, boolean newline) {
        int i;
        if (props == null || props.isEmpty()) {
            return "{}";
        }
        StringBuffer buf = new StringBuffer(props.size() * 32);
        buf.append('{');
        if (newline) {
            buf.append(SystemUtils.LINE_SEPARATOR);
        }
        Object[] entries = props.entrySet().toArray();
        int numEntries = entries.length;
        for (i = 0; i < numEntries - 1; ++i) {
            PropertiesUtils.appendMaskedProperty(buf, (Map.Entry)entries[i]);
            if (newline) {
                buf.append(SystemUtils.LINE_SEPARATOR);
                continue;
            }
            buf.append(',').append(' ');
        }
        PropertiesUtils.appendMaskedProperty(buf, (Map.Entry)entries[i]);
        if (newline) {
            buf.append(SystemUtils.LINE_SEPARATOR);
        }
        buf.append('}');
        return buf.toString();
    }

    private static void appendMaskedProperty(StringBuffer buffer, Map.Entry property) {
        String key = property.getKey().toString();
        buffer.append(key).append('=');
        if (maskedProperties.contains(key)) {
            buffer.append("*****");
        } else {
            buffer.append(property.getValue());
        }
    }

    public static Map getMessageProperties(UMOMessage message) {
        return PropertiesUtils.getMessageProperties(new ArrayList(message.getPropertyNames()), message, null);
    }

    public static Map getMessageProperties(List propertyNames, UMOMessage message) {
        return PropertiesUtils.getMessageProperties(propertyNames, message, null);
    }

    public static Map getMessageProperties(List propertyNames, UMOMessage message, String prefixToExclude) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Iterator iterator = propertyNames.iterator();
        while (iterator.hasNext()) {
            String prop = (String)iterator.next();
            if (prefixToExclude != null && prop.startsWith(prefixToExclude)) continue;
            props.put(prop, message.getProperty(prop));
        }
        return props;
    }

    static {
        PropertiesUtils.registeredMaskedPropertyName("password");
    }
}

