/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Multicaster {
    public static Object create(Class theInterface, Collection objects) {
        return Multicaster.create(new Class[]{theInterface}, objects);
    }

    public static Object create(Class theInterface, Collection objects, InvokeListener listener) {
        return Multicaster.create(new Class[]{theInterface}, objects, listener);
    }

    public static Object create(Class[] interfaces, Collection objects) {
        return Multicaster.create(interfaces, objects, null);
    }

    public static Object create(Class[] interfaces, Collection objects, InvokeListener listener) {
        Object proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, (InvocationHandler)new CastingHandler(objects, listener));
        return proxy;
    }

    public static interface InvokeListener {
        public void afterExecute(Object var1, Method var2, Object[] var3);

        public Throwable onException(Object var1, Method var2, Object[] var3, Throwable var4);
    }

    private static class CastingHandler
    implements InvocationHandler {
        private final Collection objects;
        private final InvokeListener listener;

        public CastingHandler(Collection objects) {
            this(objects, null);
        }

        public CastingHandler(Collection objects, InvokeListener listener) {
            this.objects = objects;
            this.listener = listener;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ArrayList<Object> results = new ArrayList<Object>();
            Object item = null;
            Iterator iterator = this.objects.iterator();
            while (iterator.hasNext()) {
                try {
                    item = iterator.next();
                    Object result = method.invoke(item, args);
                    if (this.listener != null) {
                        this.listener.afterExecute(item, method, args);
                    }
                    if (result == null) continue;
                    results.add(result);
                }
                catch (Throwable t) {
                    if (this.listener == null || (t = this.listener.onException(item, method, args, t)) == null) continue;
                    throw t;
                }
            }
            return results;
        }
    }
}

