/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.compression;

import java.io.IOException;
import org.apache.commons.lang.SerializationUtils;
import org.mule.transformers.compression.GZipCompressTransformer;
import org.mule.umo.transformer.TransformerException;
import org.mule.util.compression.GZipCompression;

public class GZipUncompressTransformer
extends GZipCompressTransformer {
    private static final long serialVersionUID = -861180612454404077L;

    public GZipUncompressTransformer() {
        this.setStrategy(new GZipCompression());
        this.registerSourceType([B.class);
        this.setReturnClass([B.class);
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        byte[] buffer = null;
        try {
            buffer = this.getStrategy().uncompressByteArray((byte[])src);
        }
        catch (IOException e) {
            this.logger.error((Object)"Failed to uncompress message:", (Throwable)e);
            throw new TransformerException(this, (Throwable)e);
        }
        if (!this.getReturnClass().equals([B.class)) {
            return SerializationUtils.deserialize((byte[])buffer);
        }
        return buffer;
    }
}

