/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import org.mule.routing.inbound.AbstractEventAggregator;
import org.mule.routing.inbound.EventGroup;
import org.mule.umo.UMOEvent;

public abstract class CorrelationAggregator
extends AbstractEventAggregator {
    protected boolean shouldAggregate(EventGroup events) {
        int size = events.expectedSize();
        if (size == -1) {
            this.logger.warn((Object)"Correlation Group Size not set, but CorrelationAggregator is being used.  Message is being forwarded");
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Aggregator: Current Event groups = " + this.eventGroups.size()));
            this.logger.debug((Object)("correlation size is " + size + ". current event group size is " + events.size() + " for correlation " + events.getGroupId()));
        }
        return size == events.size();
    }

    protected EventGroup addEvent(UMOEvent event) {
        EventGroup eg;
        String cId = event.getMessage().getCorrelationId();
        int groupSize = event.getMessage().getCorrelationGroupSize();
        if (cId == null) {
            cId = "no-id";
        }
        if ((eg = (EventGroup)this.eventGroups.get(cId)) == null) {
            eg = new EventGroup(cId, groupSize);
            eg.addEvent(event);
            this.eventGroups.put(eg.getGroupId(), eg);
        } else {
            eg.addEvent(event);
        }
        return eg;
    }
}

