/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleRuntimeException;
import org.mule.config.DefaultExceptionReader;
import org.mule.config.ExceptionReader;
import org.mule.config.NamingExceptionReader;
import org.mule.config.UMOExceptionReader;
import org.mule.config.i18n.Message;
import org.mule.umo.UMOException;
import org.mule.util.ClassUtils;
import org.mule.util.SpiUtils;
import org.mule.util.StringUtils;

public class ExceptionHelper {
    public static final String ERROR_CODE_PROPERTY = "error.code.property";
    public static final String APPLY_TO_PROPERTY = "apply.to";
    protected static transient Log logger = LogFactory.getLog((Class)ExceptionHelper.class);
    private static Properties errorDocs = new Properties();
    private static Properties errorCodes = new Properties();
    private static Map reverseErrorCodes = null;
    private static Map errorMappings = new HashMap();
    private static int exceptionThreshold = 0;
    private static boolean verbose = true;
    private static boolean initialised = false;
    private static String J2SE_VERSION = "";
    private static String J2EE_VERSION = "1.3ee";
    private static List exceptionReaders = new ArrayList();
    private static ExceptionReader defaultExceptionReader = new DefaultExceptionReader();
    static /* synthetic */ Class class$java$lang$Object;

    public static void initialise() {
        try {
            if (initialised) {
                return;
            }
            ExceptionHelper.registerExceptionReader(new UMOExceptionReader());
            ExceptionHelper.registerExceptionReader(new NamingExceptionReader());
            J2SE_VERSION = System.getProperty("java.specification.version");
            InputStream is = SpiUtils.findServiceDescriptor("org/mule/config", "mule-exception-codes.properties", ExceptionHelper.class);
            if (is == null) {
                throw new NullPointerException("Failed to load resource: META_INF/services/org/mule/config/mule-exception-codes.properties");
            }
            errorCodes.load(is);
            reverseErrorCodes = MapUtils.invertMap((Map)errorCodes);
            is = SpiUtils.findServiceDescriptor("org/mule/config", "mule-exception-config.properties", ExceptionHelper.class);
            if (is == null) {
                throw new NullPointerException("Failed to load resource: META_INF/services/org/mule/config/mule-exception-config.properties");
            }
            errorDocs.load(is);
            initialised = true;
        }
        catch (IOException e) {
            throw new MuleRuntimeException(Message.createStaticMessage("Failed to load Exception resources"), (Throwable)e);
        }
    }

    public static int getErrorCode(Class exception) {
        String code = errorCodes.getProperty(exception.getName(), "-1");
        return Integer.parseInt(code);
    }

    public static Class getErrorClass(int code) {
        String key = String.valueOf(code);
        Object clazz = reverseErrorCodes.get(key);
        if (clazz == null) {
            return null;
        }
        if (clazz instanceof Class) {
            return (Class)clazz;
        }
        try {
            clazz = ClassUtils.loadClass(clazz.toString(), ExceptionHelper.class);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        reverseErrorCodes.put(key, clazz);
        return (Class)clazz;
    }

    public static String getErrorMapping(String protocol, int code) {
        Class c = ExceptionHelper.getErrorClass(code);
        if (c != null) {
            return ExceptionHelper.getErrorMapping(protocol, c);
        }
        logger.error((Object)("Class not known for code: " + code));
        return "-1";
    }

    private static Properties getErrorMappings(String protocol) {
        Object m = errorMappings.get(protocol);
        if (m != null) {
            if (m instanceof Properties) {
                return (Properties)m;
            }
            return null;
        }
        InputStream is = SpiUtils.findServiceDescriptor("org/mule/config", protocol + "-exception-mappings.properties", ExceptionHelper.class);
        if (is == null) {
            errorMappings.put(protocol, "not found");
            logger.warn((Object)("Failed to load error mappings from: META-INF/services/org/mule/config/" + protocol + "-exception-mappings.properties. This may be because there are no error code mappings for protocol: " + protocol));
            return null;
        }
        Properties p = new Properties();
        try {
            p.load(is);
        }
        catch (IOException e) {
            throw new MuleRuntimeException(Message.createStaticMessage("Failed to load Exception resources"), (Throwable)e);
        }
        errorMappings.put(protocol, p);
        String applyTo = p.getProperty(APPLY_TO_PROPERTY, null);
        if (applyTo != null) {
            String[] protocols = StringUtils.split(applyTo, ",");
            for (int i = 0; i < protocols.length; ++i) {
                errorMappings.put(protocols[i], p);
            }
        }
        return p;
    }

    public static String getErrorCodePropertyName(String protocol) {
        Properties mappings = ExceptionHelper.getErrorMappings(protocol = protocol.toLowerCase());
        if (mappings == null) {
            return null;
        }
        return mappings.getProperty(ERROR_CODE_PROPERTY);
    }

    public static String getErrorMapping(String protocol, Class exception) {
        Properties mappings = ExceptionHelper.getErrorMappings(protocol = protocol.toLowerCase());
        if (mappings == null) {
            logger.info((Object)("No mappings found for protocol: " + protocol));
            return String.valueOf(ExceptionHelper.getErrorCode(exception));
        }
        Class clazz = exception;
        String code = null;
        while (!clazz.equals(class$java$lang$Object == null ? ExceptionHelper.class$("java.lang.Object") : class$java$lang$Object)) {
            code = mappings.getProperty(clazz.getName());
            if (code == null) {
                clazz = clazz.getSuperclass();
                continue;
            }
            return code;
        }
        code = String.valueOf(ExceptionHelper.getErrorCode(exception));
        return mappings.getProperty(code, code);
    }

    public static String getJavaDocUrl(Class exception) {
        return ExceptionHelper.getDocUrl("javadoc.", exception.getName());
    }

    public static String getDocUrl(Class exception) {
        return ExceptionHelper.getDocUrl("doc.", exception.getName());
    }

    private static String getDocUrl(String prefix, String packageName) {
        String url;
        String key = prefix;
        if (packageName.startsWith("java.") || packageName.startsWith("javax.")) {
            key = key + J2SE_VERSION;
        }
        if ((url = ExceptionHelper.getUrl(key, packageName)) == null && (packageName.startsWith("java.") || packageName.startsWith("javax."))) {
            key = prefix + J2EE_VERSION;
            url = ExceptionHelper.getUrl(key, packageName);
        }
        if (url != null) {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            String s = packageName.replaceAll("[.]", "/");
            s = s + ".html";
            url = url + s;
        }
        return url;
    }

    private static String getUrl(String key, String packageName) {
        String url = null;
        if (!key.endsWith(".")) {
            key = key + ".";
        }
        while (packageName.length() > 0 && (url = errorDocs.getProperty(key + packageName, null)) == null) {
            int i = packageName.lastIndexOf(".");
            if (i == -1) {
                packageName = "";
                continue;
            }
            packageName = packageName.substring(0, i);
        }
        return url;
    }

    public static Throwable getRootException(Throwable t) {
        Throwable cause = t;
        Throwable root = null;
        while (cause != null) {
            root = cause;
            cause = ExceptionHelper.getExceptionReader(cause).getCause(cause);
        }
        return root;
    }

    public static Throwable getRootParentException(Throwable t) {
        Throwable cause = t;
        Throwable parent = t;
        while (cause != null) {
            if (cause.getCause() == null) {
                return parent;
            }
            parent = cause;
            cause = ExceptionHelper.getExceptionReader(cause).getCause(cause);
        }
        return t;
    }

    public static UMOException getRootMuleException(Throwable t) {
        Throwable cause = t;
        UMOException umoException = null;
        while (cause != null) {
            if (cause instanceof UMOException) {
                umoException = (UMOException)cause;
            }
            cause = ExceptionHelper.getExceptionReader(cause).getCause(cause);
        }
        return umoException;
    }

    public static List getExceptionsAsList(Throwable t) {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        Throwable cause = t;
        while (cause != null) {
            exceptions.add(0, cause);
            cause = ExceptionHelper.getExceptionReader(cause).getCause(cause);
        }
        return exceptions;
    }

    public static Map getExceptionInfo(Throwable t) {
        HashMap info = new HashMap();
        Throwable cause = t;
        while (cause != null) {
            info.putAll(ExceptionHelper.getExceptionReader(cause).getInfo(cause));
            cause = ExceptionHelper.getExceptionReader(cause).getCause(cause);
        }
        return info;
    }

    public static String getExceptionStack(Throwable t) {
        StringBuffer buf = new StringBuffer();
        List exceptions = ExceptionHelper.getExceptionsAsList(t);
        int i = 1;
        Iterator iterator = exceptions.iterator();
        while (iterator.hasNext()) {
            if (i > exceptionThreshold && exceptionThreshold > 0) {
                buf.append("(").append(exceptions.size() - i + 1).append(" more...)");
                break;
            }
            Throwable throwable = (Throwable)iterator.next();
            ExceptionReader er = ExceptionHelper.getExceptionReader(throwable);
            buf.append(i).append(". ").append(er.getMessage(throwable)).append(" (");
            buf.append(throwable.getClass().getName()).append(")\n");
            if (verbose && throwable.getStackTrace().length > 0) {
                StackTraceElement e = throwable.getStackTrace()[0];
                buf.append("  ").append(e.getClassName()).append(":").append(e.getLineNumber()).append(" (").append(ExceptionHelper.getJavaDocUrl(throwable.getClass())).append(")\n");
            }
            ++i;
        }
        return buf.toString();
    }

    public static void registerExceptionReader(ExceptionReader reader) {
        exceptionReaders.add(reader);
    }

    public static ExceptionReader getExceptionReader(Throwable t) {
        Iterator iterator = exceptionReaders.iterator();
        while (iterator.hasNext()) {
            ExceptionReader exceptionReader = (ExceptionReader)iterator.next();
            if (!exceptionReader.getExceptionType().isInstance(t)) continue;
            return exceptionReader;
        }
        return defaultExceptionReader;
    }

    public static String writeException(Throwable t) {
        ExceptionReader er = ExceptionHelper.getExceptionReader(t);
        StringBuffer msg = new StringBuffer();
        msg.append(er.getMessage(t)).append(". Type: ").append(t.getClass());
        return msg.toString();
    }

    static {
        ExceptionHelper.initialise();
    }
}

