/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.internal.xpath;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathVariableResolver;
import org.mule.module.xml.api.NamespaceMapping;
import org.mule.module.xml.internal.error.InvalidXPathExpressionException;
import org.mule.module.xml.internal.error.TransformationException;
import org.mule.module.xml.internal.xpath.XPathNamespaceContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathEvaluator
implements XPathVariableResolver {
    private static final boolean DEFAULT_KEEP_TRAILING_NEWLINES = false;
    private static final String UNSUPPORTED_XPATH_EXPRESSION_MESSAGE = "Cannot convert XPath value to Java object: required class is org.w3c.dom.NodeList";
    private final XPathExpression xpathExpression;
    private Map<String, Object> contextProperties;
    private Transformer toString;
    private boolean keepTrailingNewlines;
    private String expression;

    public XPathEvaluator(String expression, XPathFactory xpathFactory, Collection<NamespaceMapping> namespaces) {
        this.expression = expression;
        XPath xpath = xpathFactory.newXPath();
        xpath.setXPathVariableResolver(this);
        xpath.setNamespaceContext(new XPathNamespaceContext(namespaces.stream().collect(Collectors.toMap(NamespaceMapping::getPrefix, NamespaceMapping::getUri))));
        try {
            this.xpathExpression = xpath.compile(expression);
        }
        catch (Exception e) {
            throw new InvalidXPathExpressionException("Could not compile xpath expression " + expression, e);
        }
        try {
            this.toString = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        this.toString.setOutputProperty("omit-xml-declaration", "yes");
        this.toString.setOutputProperty("indent", "yes");
        this.keepTrailingNewlines = false;
        this.reset();
    }

    public List<String> evaluate(Node input, Map<String, Object> contextProperties) {
        this.contextProperties = contextProperties;
        try {
            return this.toStringList((NodeList)this.xpathExpression.evaluate(input, XPathConstants.NODESET));
        }
        catch (XPathExpressionException e) {
            if (e.getMessage().contains(UNSUPPORTED_XPATH_EXPRESSION_MESSAGE)) {
                throw this.unsupportedException(e);
            }
            throw this.transformationException(e);
        }
        catch (Exception e) {
            throw this.transformationException(e);
        }
    }

    private TransformationException unsupportedException(XPathExpressionException e) {
        return new TransformationException(String.format("Unsupported XPath expression '%s'. %s", this.expression, e.getMessage()), e);
    }

    private TransformationException transformationException(Exception e) {
        return new TransformationException(String.format("Failed to evaluate XPath expression '%s'. %s", this.expression, e.getMessage()), e);
    }

    private List<String> toStringList(NodeList nodeList) throws TransformerException {
        int size = nodeList.getLength();
        ArrayList<String> strings = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            Node item = nodeList.item(i);
            if (item.getNodeType() == 2) {
                strings.add(item.getTextContent());
                continue;
            }
            StringWriter sw = new StringWriter();
            this.toString.transform(new DOMSource(item), new StreamResult(sw));
            strings.add(this.cleanTrailingNewlineIfNecessary(sw.toString()));
        }
        return strings;
    }

    private String cleanTrailingNewlineIfNecessary(String line) {
        if (!this.keepTrailingNewlines && line.endsWith("\n")) {
            line = line.substring(0, line.lastIndexOf(10));
        }
        return line;
    }

    @Override
    public Object resolveVariable(QName variableName) {
        return this.contextProperties.get(variableName.getLocalPart());
    }

    public void reset() {
        this.contextProperties = Collections.emptyMap();
    }

    public XPathEvaluator keepingTrailingNewlines(boolean shouldKeepTrailingNewlines) {
        this.keepTrailingNewlines = shouldKeepTrailingNewlines;
        return this;
    }
}

