/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.internal.operation;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.xpath.XPathFactoryImpl;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.mule.module.xml.api.EntityExpansion;
import org.mule.module.xml.api.NamespaceDirectory;
import org.mule.module.xml.api.NamespaceMapping;
import org.mule.module.xml.internal.XmlModule;
import org.mule.module.xml.internal.error.XPathErrorTypeProvider;
import org.mule.module.xml.internal.operation.PooledTransformerOperation;
import org.mule.module.xml.internal.util.XMLUtils;
import org.mule.module.xml.internal.xpath.XPathEvaluator;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;

public class XPathOperation
extends PooledTransformerOperation<XPathKey, XPathEvaluator>
implements Initialisable {
    private final XPathFactory xpathFactory = new XPathFactoryImpl();

    public XPathOperation() {
    }

    public XPathOperation(EntityExpansion expandEntities) {
        this.expandEntities = expandEntities;
    }

    @Execution(value=ExecutionType.CPU_INTENSIVE)
    @Throws(value={XPathErrorTypeProvider.class})
    public List<String> xpathExtract(@Content(primary=true) InputStream content, String xpath, @Optional @Content @NullSafe Map<String, Object> contextProperties, @Optional @NullSafe List<NamespaceMapping> namespaces, @Optional @ParameterDsl(allowInlineDefinition=false) NamespaceDirectory namespaceDirectory, @Config XmlModule config, @Optional(defaultValue="false") boolean addTrailingNewlines) {
        return (List)this.withTransformer(new XPathKey(xpath, this.mergeNamespaces(namespaces, namespaceDirectory)), evaluator -> evaluator.keepingTrailingNewlines(addTrailingNewlines).evaluate(XMLUtils.toDOMNode(content, this.documentBuilderFactory), contextProperties));
    }

    Collection<NamespaceMapping> mergeNamespaces(List<NamespaceMapping> namespaces, NamespaceDirectory directory) {
        HashSet<NamespaceMapping> merge = new HashSet<NamespaceMapping>();
        if (namespaces != null) {
            merge.addAll(namespaces);
        }
        if (directory != null && directory.getNamespaces() != null) {
            merge.addAll(directory.getNamespaces());
        }
        return merge;
    }

    @Override
    protected BasePooledObjectFactory<XPathEvaluator> createPooledObjectFactory(final XPathKey key) {
        return new BasePooledObjectFactory<XPathEvaluator>(){

            public XPathEvaluator create() throws Exception {
                return new XPathEvaluator(key.xpath, XPathOperation.this.xpathFactory, key.namespaces);
            }

            public void passivateObject(PooledObject<XPathEvaluator> p) throws Exception {
                ((XPathEvaluator)p.getObject()).reset();
            }

            public PooledObject<XPathEvaluator> wrap(XPathEvaluator evaluator) {
                return new DefaultPooledObject((Object)evaluator);
            }
        };
    }

    class XPathKey {
        private final String xpath;
        private final Collection<NamespaceMapping> namespaces;

        public XPathKey(String xpath, Collection<NamespaceMapping> namespaces) {
            this.xpath = xpath;
            this.namespaces = namespaces;
        }

        public boolean equals(Object obj) {
            XPathKey other = (XPathKey)obj;
            return Objects.equals(this.xpath, other.xpath) && Objects.equals(this.namespaces, other.namespaces);
        }

        public int hashCode() {
            return Objects.hash(this.xpath, this.namespaces);
        }
    }
}

