/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.internal.operation;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.mule.module.xml.api.EntityExpansion;
import org.mule.module.xml.api.SchemaLanguage;
import org.mule.module.xml.api.SchemaValidationException;
import org.mule.module.xml.api.SchemaViolation;
import org.mule.module.xml.internal.XmlModule;
import org.mule.module.xml.internal.error.InvalidInputXmlException;
import org.mule.module.xml.internal.error.InvalidSchemaException;
import org.mule.module.xml.internal.error.SchemaValidatorErrorTypeProvider;
import org.mule.module.xml.internal.error.TransformationException;
import org.mule.module.xml.internal.operation.PooledTransformerOperation;
import org.mule.module.xml.internal.util.MuleResourceResolver;
import org.mule.module.xml.internal.util.XMLUtils;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaValidatorOperation
extends PooledTransformerOperation<SchemaKey, Validator> {
    private LSResourceResolver resourceResolver = new MuleResourceResolver();

    @org.mule.runtime.extension.api.annotation.param.stereotype.Validator
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    @Throws(value={SchemaValidatorErrorTypeProvider.class})
    public void validateSchema(@Path(type=PathModel.Type.FILE, acceptedFileExtensions={"xsd"}) String schemas, @Optional(defaultValue="W3C") SchemaLanguage schemaLanguage, @Content(primary=true) InputStream content, @Config XmlModule config) {
        this.withTransformer(new SchemaKey(schemas, schemaLanguage.getLanguageUri(), this.expandEntities), validator -> {
            validator.setResourceResolver(this.resourceResolver);
            final LinkedList<SchemaViolation> errors = new LinkedList<SchemaViolation>();
            final LinkedList<SchemaViolation> fatalErrors = new LinkedList<SchemaViolation>();
            validator.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) {
                }

                @Override
                public void error(SAXParseException exception) {
                    this.trackError(exception);
                }

                @Override
                public void fatalError(SAXParseException exception) {
                    fatalErrors.add(new SchemaViolation(exception.getLineNumber(), exception.getColumnNumber(), exception.getMessage()));
                    this.trackError(exception);
                }

                private void trackError(SAXParseException exception) {
                    errors.add(new SchemaViolation(exception.getLineNumber(), exception.getColumnNumber(), exception.getMessage()));
                }
            });
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                spf.setFeature("http://xml.org/sax/features/external-general-entities", this.expandEntities.isAcceptExternalEntities());
                spf.setFeature("http://xml.org/sax/features/external-parameter-entities", this.expandEntities.isAcceptExternalEntities());
                spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", !this.expandEntities.isExpandInternalEntities());
                spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", this.expandEntities.isExpandInternalEntities());
                validator.validate(new SAXSource(spf.newSAXParser().getXMLReader(), new InputSource(content)));
            }
            catch (SAXParseException e) {
                if (!fatalErrors.isEmpty()) {
                    SchemaValidationException schemaValidationException = new SchemaValidationException("Input XML was not compliant with the schema. Check this error's Mule message for the list of problems (e.g: #[error.errorMessage.payload[0].description)", fatalErrors);
                    throw new InvalidInputXmlException("Cannot parse input XML because it is invalid.", (Throwable)((Object)schemaValidationException));
                }
                throw new TransformationException("Failed to validate schema. " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new InvalidInputXmlException("Could not validate schema because the input was not valid XML. " + e.getMessage(), e);
            }
            if (!errors.isEmpty()) {
                throw new SchemaValidationException("Input XML was not compliant with the schema. Check this error's Mule message for the list of problems (e.g: #[error.errorMessage.payload[0].description)", errors);
            }
            return null;
        });
    }

    @Override
    protected BasePooledObjectFactory<Validator> createPooledObjectFactory(final SchemaKey key) {
        return new BasePooledObjectFactory<Validator>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Validator create() {
                SchemaFactory schemaFactory;
                Source[] schemas = SchemaValidatorOperation.this.loadSchemas(key.schemas);
                SchemaFactory schemaFactory2 = schemaFactory = XMLSecureFactories.createWithConfig((Boolean)key.expandEntities.isAcceptExternalEntities(), (Boolean)key.expandEntities.isExpandInternalEntities()).getSchemaFactory(key.schemaLanguage);
                synchronized (schemaFactory2) {
                    Schema schema;
                    schemaFactory.setResourceResolver(SchemaValidatorOperation.this.resourceResolver);
                    try {
                        schema = schemaFactory.newSchema(schemas);
                    }
                    catch (SAXException e) {
                        throw new InvalidSchemaException("The supplied schemas were not valid. " + e.getMessage(), e);
                    }
                    return schema.newValidator();
                }
            }

            public void passivateObject(PooledObject<Validator> p) {
                ((Validator)p.getObject()).setErrorHandler(null);
                ((Validator)p.getObject()).reset();
            }

            public PooledObject<Validator> wrap(Validator validator) {
                return new DefaultPooledObject((Object)validator);
            }
        };
    }

    private Source[] loadSchemas(Set<String> paths) {
        Source[] schemas = new Source[paths.size()];
        int i = 0;
        for (String path : paths) {
            try {
                URL resourceAsUrl = IOUtils.getResourceAsUrl((String)path, this.getClass());
                if (resourceAsUrl == null) {
                    throw new InvalidSchemaException(String.format("Schema '%s' could not be found", path));
                }
                schemas[i++] = new DOMSource(XMLUtils.toDOMNode(resourceAsUrl.openStream(), this.documentBuilderFactory), resourceAsUrl.toString());
            }
            catch (Exception e) {
                throw new InvalidSchemaException(String.format("Failed to load schema '%s'. %s", path, e.getMessage()), e);
            }
        }
        return schemas;
    }

    class SchemaKey {
        private final Set<String> schemas;
        private final String schemaLanguage;
        private final EntityExpansion expandEntities;

        public SchemaKey(String schemas, String schemaLanguage, EntityExpansion expandEntities) {
            this.schemas = this.parseSchemas(schemas);
            this.schemaLanguage = schemaLanguage;
            this.expandEntities = expandEntities;
        }

        private Set<String> parseSchemas(String schemas) {
            if (StringUtils.isBlank((String)schemas)) {
                return Collections.emptySet();
            }
            return Stream.of(schemas.split(",")).map(String::trim).collect(Collectors.toCollection(HashSet::new));
        }

        public boolean equals(Object obj) {
            SchemaKey other = (SchemaKey)obj;
            if (other == null) {
                return false;
            }
            return Objects.equals(this.schemas, other.schemas) && Objects.equals(this.schemaLanguage, other.schemaLanguage) && this.expandEntities == other.expandEntities;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.schemas, this.schemaLanguage, this.expandEntities});
        }
    }
}

