/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.validator;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.extension.validation.api.ValidationErrorType;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.validator.AbstractValidator;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Preconditions;

public class SizeValidator
extends AbstractValidator {
    private final TypedValue typedValue;
    private final int minSize;
    private final Integer maxSize;
    private final ExpressionLanguage expressionLanguage;
    private static final String PAYLOAD = "payload";
    private static final String FAILED_EXPRESSION_MESSAGE = "There was a problem while calculating the size for the validation";
    private I18nMessage errorMessage;

    public SizeValidator(TypedValue typedValue, int minSize, Integer maxSize, ValidationContext validationContext, ExpressionLanguage expressionLanguage) {
        super(validationContext);
        this.typedValue = typedValue;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.expressionLanguage = expressionLanguage;
    }

    @Override
    public ValidationResult validate() {
        int inputLength = this.getSize((TypedValue<Object>)this.typedValue);
        if (inputLength < this.minSize) {
            this.errorMessage = this.getMessages().lowerThanMinSize(this.typedValue.getValue(), this.minSize, inputLength);
            return this.fail();
        }
        if (this.maxSize != null && inputLength > this.maxSize) {
            this.errorMessage = this.getMessages().greaterThanMaxSize(this.typedValue.getValue(), this.maxSize, inputLength);
            return this.fail();
        }
        return ImmutableValidationResult.ok();
    }

    private int getSize(TypedValue<Object> typedValue) {
        Preconditions.checkArgument((typedValue.getValue() != null ? 1 : 0) != 0, (String)"Cannot check size of a null value");
        return this.getSizeFromJavaType(typedValue).orElseGet(() -> this.getSizeFromDataWeaveExpression(typedValue));
    }

    private Optional<Integer> getSizeFromJavaType(TypedValue<Object> typedValue) {
        if (!this.isJavaType(typedValue)) {
            return Optional.empty();
        }
        Object value = typedValue.getValue();
        if (value instanceof String) {
            return Optional.of(((String)value).length());
        }
        if (value instanceof Collection) {
            return Optional.of(((Collection)value).size());
        }
        if (value instanceof Map) {
            return Optional.of(((Map)value).size());
        }
        if (value.getClass().isArray()) {
            return Optional.of(ArrayUtils.getLength((Object)value));
        }
        return Optional.empty();
    }

    private boolean isJavaType(TypedValue<Object> typedValue) {
        String mediaTypeString = typedValue.getDataType().getMediaType().toRfcString();
        return mediaTypeString.startsWith("*/*") || mediaTypeString.startsWith("application/java");
    }

    private Integer getSizeFromDataWeaveExpression(TypedValue<Object> typedValue) {
        BindingContext context = BindingContext.builder().addBinding(PAYLOAD, typedValue).build();
        try {
            Object expressionValue = this.expressionLanguage.evaluate("#[sizeOf(payload)]", DataType.NUMBER, context).getValue();
            if (expressionValue instanceof Integer) {
                return (Integer)expressionValue;
            }
            throw new IllegalArgumentException(FAILED_EXPRESSION_MESSAGE);
        }
        catch (ExpressionExecutionException e) {
            throw new RuntimeException(FAILED_EXPRESSION_MESSAGE, e);
        }
    }

    @Override
    protected ValidationErrorType getErrorType() {
        return ValidationErrorType.INVALID_SIZE;
    }

    @Override
    protected I18nMessage getDefaultErrorMessage() {
        return this.errorMessage;
    }
}

