/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.ResourceBundle;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidationMessages
extends I18nMessageFactory {
    private static final Logger logger = LoggerFactory.getLogger(ValidationMessages.class);
    private final String bundlePath;
    private final Locale locale;

    public ValidationMessages() {
        this.bundlePath = ValidationMessages.getBundlePath((String)"validation");
        this.locale = Locale.getDefault();
    }

    public ValidationMessages(String bundlePath, String locale) {
        this.bundlePath = bundlePath;
        this.locale = StringUtils.isEmpty((String)locale) ? Locale.getDefault() : new Locale(locale);
    }

    protected ResourceBundle getBundle(String bundlePath) {
        ResourceBundle.Control control;
        if (logger.isTraceEnabled()) {
            logger.trace("Loading resource bundle: " + bundlePath + " for locale " + this.locale);
        }
        ResourceBundle bundle = (control = this.getReloadControl()) != null ? ResourceBundle.getBundle(bundlePath, this.locale, this.getClassLoader(), control) : ResourceBundle.getBundle(bundlePath, this.locale, this.getClassLoader());
        return bundle;
    }

    public I18nMessage failedBooleanValidation(boolean value, boolean expected) {
        return this.createMessage(this.bundlePath, 1, expected, value);
    }

    public I18nMessage invalidNumberType(Object value, String numberType) {
        return this.createMessage(this.bundlePath, 2, value, numberType);
    }

    public I18nMessage lowerThan(Object value, Object boundary) {
        return this.createMessage(this.bundlePath, 3, value, boundary);
    }

    public I18nMessage greaterThan(Object value, Object boundary) {
        return this.createMessage(this.bundlePath, 4, value, boundary);
    }

    public I18nMessage invalidEmail(String email) {
        return this.createMessage(this.bundlePath, 5, email);
    }

    public I18nMessage invalidIp(String ip) {
        return this.createMessage(this.bundlePath, 6, ip);
    }

    public I18nMessage rejectedIp(String ip) {
        return this.createMessage(this.bundlePath, 24, ip);
    }

    public I18nMessage lowerThanMinSize(Object value, int minSize, int actualSize) {
        return this.createMessage(this.bundlePath, 7, value, minSize, actualSize);
    }

    public I18nMessage greaterThanMaxSize(Object value, int maxSize, int actualSize) {
        return this.createMessage(this.bundlePath, 8, value, maxSize, actualSize);
    }

    public I18nMessage valueIsNull() {
        return this.createMessage(this.bundlePath, 9);
    }

    public I18nMessage collectionIsEmpty() {
        return this.createMessage(this.bundlePath, 10);
    }

    public I18nMessage stringIsBlank() {
        return this.createMessage(this.bundlePath, 11);
    }

    public I18nMessage mapIsEmpty() {
        return this.createMessage(this.bundlePath, 12);
    }

    public I18nMessage wasExpectingNull() {
        return this.createMessage(this.bundlePath, 14);
    }

    public I18nMessage invalidTime(String time, String locale, String pattern) {
        return this.createMessage(this.bundlePath, 15, time, pattern, locale);
    }

    public I18nMessage elapsedTime(LocalDateTime createdTime, Duration expiresIn, LocalDateTime currentTime) {
        return this.createMessage(this.bundlePath, 22, createdTime, expiresIn, currentTime);
    }

    public I18nMessage notElapsedTime(LocalDateTime createdTime, Duration expiresIn, LocalDateTime currentTime) {
        return this.createMessage(this.bundlePath, 23, createdTime, expiresIn, currentTime);
    }

    public I18nMessage invalidUrl(String url) {
        return this.createMessage(this.bundlePath, 16, url);
    }

    public I18nMessage regexDoesNotMatch(String value, String regex) {
        return this.createMessage(this.bundlePath, 17, value, regex);
    }

    public I18nMessage stringIsNotBlank() {
        return this.createMessage(this.bundlePath, 19);
    }

    public I18nMessage collectionIsNotEmpty() {
        return this.createMessage(this.bundlePath, 20);
    }

    public I18nMessage mapIsNotEmpty() {
        return this.createMessage(this.bundlePath, 21);
    }
}

