/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.el;

import java.util.Locale;
import org.mule.extension.validation.api.NumberType;
import org.mule.extension.validation.api.ValidationExtension;
import org.mule.extension.validation.api.ValidationOptions;
import org.mule.extension.validation.api.Validator;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.ValidationMessages;
import org.mule.extension.validation.internal.validator.EmailValidator;
import org.mule.extension.validation.internal.validator.IpValidator;
import org.mule.extension.validation.internal.validator.MatchesRegexValidator;
import org.mule.extension.validation.internal.validator.NumberValidator;
import org.mule.extension.validation.internal.validator.TimeValidator;
import org.mule.extension.validation.internal.validator.UrlValidator;
import org.mule.runtime.extension.api.annotation.param.Optional;

public final class ValidationFunctions {
    private final ValidationContext validationContext = new ValidationContext(new ValidationMessages(), new ValidationOptions());

    public boolean isEmail(String email) {
        return this.validate(new EmailValidator(email, this.validationContext));
    }

    public boolean matchesRegex(String value, String regex, @Optional(defaultValue="true") boolean caseSensitive) {
        return this.validate(new MatchesRegexValidator(value, regex, caseSensitive, this.validationContext));
    }

    public boolean isTime(String time, @Optional String pattern, @Optional String locale) {
        return this.validate(new TimeValidator(time, ValidationExtension.nullSafeLocale(locale), pattern, this.validationContext));
    }

    public boolean isNumber(String value, NumberType numberType) {
        return this.validate(new NumberValidator(value, new Locale(ValidationExtension.DEFAULT_LOCALE), null, null, null, numberType, this.validationContext));
    }

    public boolean isIp(String ip) {
        return this.validate(new IpValidator(ip, this.validationContext));
    }

    public boolean isUrl(String url) {
        return this.validate(new UrlValidator(url, this.validationContext));
    }

    private boolean validate(Validator validator) {
        return !validator.validate().isError();
    }
}

