/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.ip.address;

import java.util.regex.Pattern;
import org.mule.extension.validation.api.ValidationErrorType;
import org.mule.extension.validation.internal.ip.IpMatcher;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public abstract class IPAddress {
    private static final String IPV4_PARTIAL_ADDRESS = "(\\d{1,3})(\\.(\\d{1,3})(\\.(\\d{1,3}))?)?";
    private static final Pattern IPV4_PARTIAL_ADDRESS_PATTERN = Pattern.compile("(\\d{1,3})(\\.(\\d{1,3})(\\.(\\d{1,3}))?)?");
    private final String internalValue;

    public IPAddress(String ipAddress) {
        this.internalValue = ipAddress;
    }

    public abstract boolean isValid();

    public boolean matches(IPAddress anotherIPAddress) {
        String ipRange = anotherIPAddress.internalValue;
        String ipAddress = this.internalValue;
        if (IPV4_PARTIAL_ADDRESS_PATTERN.matcher(ipRange).matches()) {
            return this.validatePartialIpv4(ipRange, ipAddress);
        }
        return this.matcherFor(ipRange).matchIp(ipAddress);
    }

    private IpMatcher matcherFor(String ipRange) {
        IpMatcher ipAddressMatcher;
        try {
            ipAddressMatcher = new IpMatcher(ipRange);
        }
        catch (Exception e) {
            I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("'%s' is not a valid IP address or range", new Object[0]), (Object[])new Object[]{ipRange});
            throw new ModuleException(message, (ErrorTypeDefinition)ValidationErrorType.INVALID_IP, (Throwable)e);
        }
        return ipAddressMatcher;
    }

    private boolean validatePartialIpv4(String partialIp, String ipAddress) {
        if (!partialIp.endsWith(".")) {
            partialIp = partialIp + ".";
        }
        String formattedPartialIp = partialIp.replaceAll("\\.", "\\\\.");
        return Pattern.compile(formattedPartialIp).matcher(ipAddress).find();
    }
}

