/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.validator;

import java.util.Collection;
import org.mule.extension.validation.api.ValidationErrorType;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.validator.AbstractValidator;
import org.mule.runtime.api.i18n.I18nMessage;

public class NotEmptyCollectionValidator
extends AbstractValidator {
    private final Collection<?> value;
    private I18nMessage errorMessage;

    public NotEmptyCollectionValidator(Collection<?> value, ValidationContext validationContext) {
        super(validationContext);
        this.value = value;
    }

    @Override
    public ValidationResult validate() {
        if (this.value == null) {
            this.errorMessage = this.getMessages().valueIsNull();
            return this.fail();
        }
        if (this.value.isEmpty()) {
            this.errorMessage = this.getMessages().collectionIsEmpty();
            return this.fail();
        }
        return ImmutableValidationResult.ok();
    }

    @Override
    protected ValidationErrorType getErrorType() {
        return ValidationErrorType.EMPTY_COLLECTION;
    }

    @Override
    protected I18nMessage getDefaultErrorMessage() {
        return this.errorMessage;
    }
}

