/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.privileged;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.exception.EventProcessingException;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.HasMessageProcessors;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

abstract class AggregateOperationExecutor
implements ComponentExecutor<OperationModel> {
    AggregateOperationExecutor() {
    }

    public Publisher<Object> execute(ExecutionContext<OperationModel> executionContext) {
        HasMessageProcessors chain = (HasMessageProcessors)executionContext.getParameter("validations");
        ExecutionContextAdapter context = (ExecutionContextAdapter)executionContext;
        CoreEvent event = context.getEvent();
        Optional<ComponentLocation> location = Optional.ofNullable(context.getComponent().getLocation());
        ArrayList<Error> errors = new ArrayList<Error>(chain.getMessageProcessors().size());
        for (Processor processor : chain.getMessageProcessors()) {
            BaseEventContext childContext = MessageProcessors.newChildContext((CoreEvent)event, location);
            CoreEvent processEvent = CoreEvent.builder((EventContext)childContext, (CoreEvent)event).build();
            try {
                CoreEvent result = processor.process(processEvent);
                childContext.success(result);
            }
            catch (EventProcessingException e) {
                childContext.error((Throwable)e);
                Error error = e.getEvent().getError().orElse(null);
                if (error != null && this.isValidation(error.getErrorType())) {
                    errors.add(error);
                    continue;
                }
                return Mono.error((Throwable)e);
            }
            catch (Exception e) {
                childContext.error((Throwable)e);
                return Mono.error((Throwable)e);
            }
        }
        return this.handleValidationErrors(chain, errors);
    }

    protected abstract Publisher<Object> handleValidationErrors(HasMessageProcessors var1, List<Error> var2);

    private boolean isValidation(ErrorType errorType) {
        if (errorType == null) {
            return false;
        }
        if (MuleErrors.VALIDATION.getType().equals(errorType.getIdentifier()) && "MULE".equals(errorType.getNamespace())) {
            return true;
        }
        return this.isValidation(errorType.getParentErrorType());
    }
}

