/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.mule.extension.validation.api.IpFilterList;
import org.mule.extension.validation.api.ValidationExtension;
import org.mule.extension.validation.api.ValidationOptions;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.ValidationSupport;
import org.mule.extension.validation.internal.error.BlankErrorType;
import org.mule.extension.validation.internal.error.BooleanErrorType;
import org.mule.extension.validation.internal.error.ElapsedErrorType;
import org.mule.extension.validation.internal.error.EmailErrorType;
import org.mule.extension.validation.internal.error.EmptyErrorType;
import org.mule.extension.validation.internal.error.IpErrorType;
import org.mule.extension.validation.internal.error.IpFilterErrorType;
import org.mule.extension.validation.internal.error.NotBlankErrorType;
import org.mule.extension.validation.internal.error.NotElapsedErrorType;
import org.mule.extension.validation.internal.error.NotEmptyErrorType;
import org.mule.extension.validation.internal.error.NotNullErrorType;
import org.mule.extension.validation.internal.error.NullErrorType;
import org.mule.extension.validation.internal.error.RegexErrorType;
import org.mule.extension.validation.internal.error.SizeErrorType;
import org.mule.extension.validation.internal.error.TimeErrorType;
import org.mule.extension.validation.internal.error.UrlErrorType;
import org.mule.extension.validation.internal.validator.BlankStringValidator;
import org.mule.extension.validation.internal.validator.BooleanValidator;
import org.mule.extension.validation.internal.validator.ElapsedValidator;
import org.mule.extension.validation.internal.validator.EmailValidator;
import org.mule.extension.validation.internal.validator.EmptyCollectionValidator;
import org.mule.extension.validation.internal.validator.IpFilterValidator;
import org.mule.extension.validation.internal.validator.IpValidator;
import org.mule.extension.validation.internal.validator.MatchesRegexValidator;
import org.mule.extension.validation.internal.validator.NotBlankStringValidator;
import org.mule.extension.validation.internal.validator.NotElapsedValidator;
import org.mule.extension.validation.internal.validator.NotEmptyCollectionValidator;
import org.mule.extension.validation.internal.validator.NotNullValidator;
import org.mule.extension.validation.internal.validator.NullValidator;
import org.mule.extension.validation.internal.validator.SizeValidator;
import org.mule.extension.validation.internal.validator.TimeValidator;
import org.mule.extension.validation.internal.validator.UrlValidator;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.stereotype.Validator;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;

@Validator
public final class CommonValidationOperations
extends ValidationSupport {
    @Throws(value={BooleanErrorType.class})
    public void isTrue(boolean expression, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new BooleanValidator(expression, true, context), context);
    }

    @Throws(value={BooleanErrorType.class})
    public void isFalse(boolean expression, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new BooleanValidator(expression, false, context), context);
    }

    @Throws(value={EmailErrorType.class})
    public void isEmail(String email, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new EmailValidator(email, context), context);
    }

    @DisplayName(value="Is IP")
    @Throws(value={IpErrorType.class})
    public void isIp(String ip, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new IpValidator(ip, context), context);
    }

    @Throws(value={SizeErrorType.class})
    public void validateSize(Object value, @Optional(defaultValue="0") int min, @Optional Integer max, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new SizeValidator(value, min, max, context), context);
    }

    @Throws(value={BlankErrorType.class})
    public void isNotBlankString(@Optional(defaultValue="#[payload]") String value, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new NotBlankStringValidator(value, context), context);
    }

    @Throws(value={EmptyErrorType.class})
    public void isNotEmptyCollection(@Optional(defaultValue="#[payload]") Collection<Object> values, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new NotEmptyCollectionValidator(values, context), context);
    }

    @Throws(value={NotBlankErrorType.class})
    public void isBlankString(String value, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new BlankStringValidator(value, context), context);
    }

    @Throws(value={NotEmptyErrorType.class})
    public void isEmptyCollection(@Optional(defaultValue="#[payload]") Collection<Object> values, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new EmptyCollectionValidator(values, context), context);
    }

    @Throws(value={NullErrorType.class})
    public void isNotNull(ParameterResolver<Object> value, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new NotNullValidator(value.resolve(), context), context);
    }

    @Throws(value={NotNullErrorType.class})
    public void isNull(ParameterResolver<Object> value, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new NullValidator(value.resolve(), context), context);
    }

    @Throws(value={TimeErrorType.class})
    public void isTime(String time, @Optional String locale, @Optional String pattern, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new TimeValidator(time, ValidationExtension.nullSafeLocale(locale), pattern, context), context);
    }

    @Throws(value={NotElapsedErrorType.class})
    public void isElapsed(Long time, TimeUnit timeUnit, LocalDateTime since, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new ElapsedValidator(time, timeUnit, since, context), context);
    }

    @Throws(value={ElapsedErrorType.class})
    public void isNotElapsed(Long time, TimeUnit timeUnit, LocalDateTime since, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new NotElapsedValidator(time, timeUnit, since, context), context);
    }

    @DisplayName(value="Is URL")
    @Throws(value={UrlErrorType.class})
    public void isUrl(@DisplayName(value="URL") String url, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new UrlValidator(url, context), context);
    }

    @Throws(value={RegexErrorType.class})
    public void matchesRegex(String value, String regex, @Optional(defaultValue="true") boolean caseSensitive, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new MatchesRegexValidator(value, regex, caseSensitive, context), context);
    }

    @Throws(value={IpErrorType.class, IpFilterErrorType.class})
    public void isWhitelistedIp(String ipAddress, IpFilterList whiteList, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new IpFilterValidator(ipAddress, whiteList, true, context), context);
    }

    @Throws(value={IpErrorType.class, IpFilterErrorType.class})
    public void isNotBlacklistedIp(String ipAddress, IpFilterList blackList, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new IpFilterValidator(ipAddress, blackList, false, context), context);
    }
}

