/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mule.tracing.module.internal;

import java.util.Optional;
import org.mule.extension.mule.tracing.module.internal.MDCInjectorComponentExecutorDecorator;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutorFactory;
import org.mule.runtime.module.extension.api.loader.java.property.CompletableComponentExecutorModelProperty;

public class MDCInjectorExecutorEnricher
implements DeclarationEnricher {
    private static final String LOGGING_VARIABLE_STRING = "LoggingVariable";

    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration()).getOperations().forEach(operation -> {
            if (this.isLoggingVariableOperation((OperationDeclaration)operation)) {
                CompletableComponentExecutorFactory executorFactory = this.getExecutorFactory((OperationDeclaration)operation);
                operation.addModelProperty((ModelProperty)new CompletableComponentExecutorModelProperty(executorFactory));
            }
        });
    }

    private boolean isLoggingVariableOperation(OperationDeclaration operation) {
        return operation.getName().contains(LOGGING_VARIABLE_STRING);
    }

    private CompletableComponentExecutorFactory getExecutorFactory(OperationDeclaration operation) {
        Optional executorModelProperty = operation.getModelProperty(CompletableComponentExecutorModelProperty.class);
        Optional<CompletableComponentExecutorFactory> oldFactory = executorModelProperty.map(CompletableComponentExecutorModelProperty::getExecutorFactory);
        return (componentModel, map) -> {
            CompletableComponentExecutor delegateExecutor = oldFactory.map(f -> f.createExecutor(componentModel, map)).orElse(null);
            return new MDCInjectorComponentExecutorDecorator((CompletableComponentExecutor<ComponentModel>)delegateExecutor, operation.getName());
        };
    }
}

