/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.spring.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.mule.extension.spring.internal.util.CompoundEnumeration;

public class CompositeClassLoader
extends ClassLoader {
    private List<ClassLoader> delegates;

    public CompositeClassLoader(ClassLoader first, ClassLoader second) {
        this.delegates = first != null && second != null ? Collections.unmodifiableList(Arrays.asList(first, second)) : (first != null ? Collections.unmodifiableList(Collections.singletonList(first)) : (second != null ? Collections.unmodifiableList(Collections.singletonList(second)) : Collections.unmodifiableList(Collections.emptyList())));
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ClassNotFoundException firstException = null;
        for (ClassLoader classLoader : this.delegates) {
            try {
                Class<?> result = classLoader.loadClass(name);
                if (resolve) {
                    this.resolveClass(result);
                }
                return result;
            }
            catch (ClassNotFoundException e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
        throw new ClassNotFoundException("Class " + name + " not found - no delegate classloaders available");
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader classLoader : this.delegates) {
            URL resource = classLoader.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        for (ClassLoader classLoader : this.delegates) {
            InputStream resourceAsStream = classLoader.getResourceAsStream(name);
            if (resourceAsStream == null) continue;
            return resourceAsStream;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] tmp = new Enumeration[this.delegates.size()];
        int i = 0;
        for (ClassLoader classLoader : this.delegates) {
            tmp[i++] = classLoader.getResources(name);
        }
        return new CompoundEnumeration<URL>(tmp);
    }

    public List<ClassLoader> getDelegates() {
        return this.delegates;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.delegates.toString();
    }

    static {
        CompositeClassLoader.registerAsParallelCapable();
    }
}

