/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.spring.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.mule.extension.spring.internal.SpringSecurityProvider;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.ExternalLibraryType;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.annotation.DisplayTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ExpressionSupportAnnotation;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionLoadingDelegate;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;

public class SpringModuleExtensionModelGenerator
implements ExtensionLoadingDelegate {
    public static final String EXTENSION_NAME = "Spring";
    public static final String PREFIX_NAME = "spring";
    public static final String EXTENSION_DESCRIPTION = "Spring Module Plugin";
    public static final String VENDOR = "Mulesoft";
    public static final String VERSION = "1.5.0";
    public static final MuleVersion MIN_MULE_VERSION = new MuleVersion("4.0");
    public static final String XSD_FILE_NAME = "mule-spring.xsd";
    private static final String UNESCAPED_LOCATION_PREFIX = "http://";
    private static final String SCHEMA_LOCATION = "www.mulesoft.org/schema/mule/spring";
    private static final String SCHEMA_VERSION = "current";
    private static final String SPRING_VERSION = "5.3.34";
    private static final String SPRING_SECURITY_VERSION = "5.8.12";
    private static final String SPRING_GROUP_ID = "org.springframework";
    private static final String SPRING_SECURITY_GROUP_ID = "org.springframework.security";

    public void accept(ExtensionDeclarer extensionDeclarer, ExtensionLoadingContext extensionLoadingContext) {
        XmlDslModel xmlDslModel = XmlDslModel.builder().setPrefix(PREFIX_NAME).setXsdFileName(XSD_FILE_NAME).setSchemaVersion(VERSION).setSchemaLocation(String.format("%s/%s/%s", "http://www.mulesoft.org/schema/mule/spring", SCHEMA_VERSION, XSD_FILE_NAME)).setNamespace("http://www.mulesoft.org/schema/mule/spring").build();
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
        BaseTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)JavaTypeLoader.JAVA);
        extensionDeclarer.named(EXTENSION_NAME).describedAs(EXTENSION_DESCRIPTION).fromVendor(VENDOR).onVersion(VERSION).withCategory(Category.COMMUNITY).withXmlDsl(xmlDslModel);
        this.declareConfig(extensionDeclarer, typeLoader);
        this.declareSecurityManager(extensionDeclarer, typeBuilder, typeLoader);
        this.declareAuthorizationFilter(extensionDeclarer, typeLoader, typeBuilder);
        this.declareExternalLibraries(extensionDeclarer);
    }

    private void declareConfig(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        Optional<Method> m = Arrays.stream(extensionDeclarer.getClass().getMethods()).filter(method -> method.getName().equals("supportingJavaVersions")).filter(method -> Arrays.equals(method.getParameterTypes(), new Class[]{Set.class})).findFirst();
        if (m.isPresent()) {
            try {
                extensionDeclarer = (ExtensionDeclarer)m.get().invoke((Object)extensionDeclarer, Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("1.8", "11", "17"))));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Failed to initialize the extension when trying to declare `supportingJavaVersions` for the extension.", e);
            }
        }
        ConfigurationDeclarer springConfig = extensionDeclarer.withConfig("config").withStereotype(StereotypeModelBuilder.newStereotype((String)"CONFIG", (String)"SPRING").withParent(MuleStereotypes.APP_CONFIG).build()).describedAs("Spring configuration that allows to define a set of spring XML files and create an application context with objects to be used in the mule artifact.");
        ParameterGroupDeclarer parameterGroupDeclarer = springConfig.onDefaultParameterGroup();
        parameterGroupDeclarer.withRequiredParameter("files").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).withRole(ParameterRole.BEHAVIOUR).ofType(typeLoader.load(String.class));
    }

    private void declareSecurityManager(ExtensionDeclarer extensionDeclarer, BaseTypeBuilder typeBuilder, ClassTypeLoader typeLoader) {
        ConstructDeclarer securityManager = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("securityManager").allowingTopLevelDefinition().withStereotype(StereotypeModelBuilder.newStereotype((String)"SECURITY_MANAGER", (String)"SPRING").withParent(MuleStereotypes.APP_CONFIG).build())).describedAs("Security manager that allows configuring Spring security providers.");
        ObjectTypeBuilder securityProviderType = typeBuilder.objectType().id(SpringSecurityProvider.class.getName()).with((TypeAnnotation)new ClassInformationAnnotation(SpringSecurityProvider.class)).with((TypeAnnotation)new TypeAliasAnnotation("DelegateSecurityProvider"));
        securityProviderType.addField().key("name").description("Provider name to allow referencing it.").value(typeLoader.load(String.class)).with((TypeAnnotation)new ExpressionSupportAnnotation(ExpressionSupport.NOT_SUPPORTED)).required();
        securityProviderType.addField().key("delegate-ref").with((TypeAnnotation)new DisplayTypeAnnotation(DisplayModel.builder().displayName("Delegate Reference").build())).description("Reference to a Spring Security Manager to use.").value(typeLoader.load(String.class)).with((TypeAnnotation)new ExpressionSupportAnnotation(ExpressionSupport.NOT_SUPPORTED)).required();
        securityProviderType.addField().key("authenticationProvider-ref").with((TypeAnnotation)new DisplayTypeAnnotation(DisplayModel.builder().displayName("Authentication Provider Reference").build())).description("Reference to an authentication provider to use.").value(typeLoader.load(String.class)).with((TypeAnnotation)new ExpressionSupportAnnotation(ExpressionSupport.NOT_SUPPORTED)).required(false);
        ParameterDeclarer nameParam = securityManager.onDefaultParameterGroup().withRequiredParameter("name").ofType(typeLoader.load(String.class)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        try {
            Method declaredMethod = ParameterDeclarer.class.getDeclaredMethod("asComponentId", new Class[0]);
            nameParam = (ParameterDeclarer)declaredMethod.invoke((Object)nameParam, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException declaredMethod) {
            // empty catch block
        }
        try {
            Class<?> forName = Class.forName("org.mule.runtime.extension.api.property.NoWrapperModelProperty");
            ParameterDeclarer delegateSecurityProviders = securityManager.onDefaultParameterGroup().withRequiredParameter("delegateSecurityProviders").ofType((MetadataType)typeBuilder.arrayType().of((MetadataType)securityProviderType.build()).build()).withDsl(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build()).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).withRole(ParameterRole.BEHAVIOUR).withLayout(LayoutModel.builder().order(1).build());
            delegateSecurityProviders.withModelProperty((ModelProperty)forName.newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException e) {
            ParameterDeclarer parameterDeclarer = securityManager.onDefaultParameterGroup().withRequiredParameter("delegateSecurityProvider").ofType((MetadataType)securityProviderType.build()).withDsl(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build()).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).withRole(ParameterRole.BEHAVIOUR).withLayout(LayoutModel.builder().order(1).build());
        }
    }

    private void declareAuthorizationFilter(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader, BaseTypeBuilder typeBuilder) {
        ErrorModel anyError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.ANY).build();
        OperationDeclarer authorizationFilter = (OperationDeclarer)((OperationDeclarer)((OperationDeclarer)extensionDeclarer.withOperation("authorization-filter").describedAs("Authorize users against a required set of authorities.")).withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.SERVER_SECURITY).withParent(anyError).build())).withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.NOT_PERMITTED).withParent(anyError).build());
        authorizationFilter.withOutput().ofType((MetadataType)typeBuilder.voidType().build());
        authorizationFilter.withOutputAttributes().ofType((MetadataType)typeBuilder.voidType().build());
        authorizationFilter.onDefaultParameterGroup().withRequiredParameter("requiredAuthorities").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).withRole(ParameterRole.BEHAVIOUR).ofType(typeLoader.load(String.class));
    }

    private void declareExternalLibraries(ExtensionDeclarer extensionDeclarer) {
        extensionDeclarer.withExternalLibrary(ExternalLibraryModel.builder().withName("Spring Core").withDescription("Spring Core (http://projects.spring.io/spring-framework). Based on the application usage of the Spring Framework, other spring dependencies may be required.").withCoordinates("org.springframework:spring-core:5.3.34").withType(ExternalLibraryType.DEPENDENCY).build());
        extensionDeclarer.withExternalLibrary(ExternalLibraryModel.builder().withName("Spring Beans").withDescription("Spring Beans (http://projects.spring.io/spring-framework). Based on the application usage of the Spring Framework, other spring dependencies may be required.").withCoordinates("org.springframework:spring-beans:5.3.34").withType(ExternalLibraryType.DEPENDENCY).build());
        extensionDeclarer.withExternalLibrary(ExternalLibraryModel.builder().withName("Spring Context").withCoordinates("org.springframework:spring-context:5.3.34").withDescription("Spring Context (http://projects.spring.io/spring-framework). Based on the application usage of the Spring Framework, other spring dependencies may be required.").withType(ExternalLibraryType.DEPENDENCY).build());
        extensionDeclarer.withExternalLibrary(ExternalLibraryModel.builder().withName("Spring Security Core").withCoordinates("org.springframework.security:spring-security-core:5.8.12").withDescription("Spring Security Context (http://spring.io/spring-security). Based on the application usage of the Spring Framework, other spring/spring-security dependencies may be required.").withType(ExternalLibraryType.DEPENDENCY).build());
        extensionDeclarer.withExternalLibrary(ExternalLibraryModel.builder().withName("Spring Security Crypto").withCoordinates("org.springframework.security:spring-security-crypto:5.8.12").withDescription("Spring Security Context (http://spring.io/spring-security). Based on the application usage of the Spring Framework, other spring/spring-security dependencies may be required.").withType(ExternalLibraryType.DEPENDENCY).build());
        extensionDeclarer.withExternalLibrary(ExternalLibraryModel.builder().withName("Spring Security Config").withCoordinates("org.springframework.security:spring-security-config:5.8.12").withDescription("Spring Security Config (http://spring.io/spring-security). Based on the application usage of the Spring Framework, other spring/spring-security dependencies may be required.").withType(ExternalLibraryType.DEPENDENCY).build());
        extensionDeclarer.withExternalLibrary(ExternalLibraryModel.builder().withName("Spring Security Web").isOptional(true).withCoordinates("org.springframework.security:spring-security-web:5.8.12").withDescription("Spring Security Web (http://spring.io/spring-security). Based on the application usage of the Spring Framework, other spring/spring-security dependencies may be required.").withType(ExternalLibraryType.DEPENDENCY).build());
        extensionDeclarer.withExternalLibrary(ExternalLibraryModel.builder().withName("Spring Security LDAP").isOptional(true).withCoordinates("org.springframework.security:spring-security-ldap:5.8.12").withDescription("Spring Security LDAP (http://spring.io/spring-security). Based on the application usage of the Spring Framework, other spring/spring-security dependencies may be required.").withType(ExternalLibraryType.DEPENDENCY).build());
    }

    private boolean hasJavaSupportingMethod(ExtensionDeclarer extensionDeclarer) {
        return Arrays.stream(extensionDeclarer.getClass().getMethods()).anyMatch(method -> method.getName().equals("supportingJavaVersions"));
    }
}

