/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.spring.internal.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.extension.spring.api.SpringConfig;
import org.mule.extension.spring.api.security.SpringProviderAdapter;
import org.mule.extension.spring.internal.security.AuthorizationFilter;
import org.mule.extension.spring.internal.security.SecurityProperty;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.security.MuleSecurityManagerConfigurator;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.security.SecurityProvider;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.dsl.api.component.TypeDefinition;

public class SpringComponentBuildingDefinitionProvider
implements ComponentBuildingDefinitionProvider {
    private final ComponentBuildingDefinition.Builder baseDefinition = new ComponentBuildingDefinition.Builder().withNamespace("spring");

    public void init() {
    }

    public List<ComponentBuildingDefinition> getComponentBuildingDefinitions() {
        ArrayList<ComponentBuildingDefinition> definitions = new ArrayList<ComponentBuildingDefinition>();
        definitions.add(this.baseDefinition.withIdentifier("config").withTypeDefinition(TypeDefinition.fromType(SpringConfig.class)).withSetterParameterDefinition("parameters", AttributeDefinition.Builder.fromUndefinedSimpleAttributes().build()).alwaysEnabled(true).build());
        definitions.addAll(this.getSpringSecurityDefinitions());
        return definitions;
    }

    private List<ComponentBuildingDefinition> getSpringSecurityDefinitions() {
        ArrayList<ComponentBuildingDefinition> componentBuildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        componentBuildingDefinitions.add(this.baseDefinition.withIdentifier("security-manager").alwaysEnabled(true).withTypeDefinition(TypeDefinition.fromType(SecurityManager.class)).withObjectFactoryType(MuleSecurityManagerConfigurator.class).withSetterParameterDefinition("muleContext", AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).withSetterParameterDefinition("name", AttributeDefinition.Builder.fromSimpleParameter((String)"name").build()).withSetterParameterDefinition("providers", AttributeDefinition.Builder.fromChildCollectionConfiguration(SecurityProvider.class).build()).build());
        componentBuildingDefinitions.add(this.baseDefinition.withIdentifier("delegate-security-provider").withTypeDefinition(TypeDefinition.fromType(SpringProviderAdapter.class)).withSetterParameterDefinition("name", AttributeDefinition.Builder.fromSimpleParameter((String)"name").build()).withSetterParameterDefinition("securityProperties", AttributeDefinition.Builder.fromChildCollectionConfiguration(SecurityProperty.class).build()).withSetterParameterDefinition("delegate", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"delegate-ref").build()).withSetterParameterDefinition("authenticationProvider", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"authenticationProvider-ref").build()).build());
        componentBuildingDefinitions.add(this.baseDefinition.withIdentifier("security-property").withTypeDefinition(TypeDefinition.fromType(SecurityProperty.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"name").build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"value").build()).build());
        componentBuildingDefinitions.add(this.baseDefinition.withIdentifier("authorization-filter").withTypeDefinition(TypeDefinition.fromType(AuthorizationFilter.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"requiredAuthorities", value -> Arrays.asList(((String)value).split(",")).stream().map(String::trim).collect(Collectors.toList())).build()).build());
        return componentBuildingDefinitions;
    }
}

