/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.spring.internal.factory;

import org.mule.runtime.api.util.Preconditions;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

public class ConstantFactoryBean<T>
implements FactoryBean<T> {
    private final T value;

    public ConstantFactoryBean(T value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"value cannot be null");
        this.value = value;
    }

    public T getObject() throws Exception {
        return this.value;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getObjectType() {
        return this.value.getClass();
    }

    public static <T> BeanDefinition getBeanDefinition(T value) {
        return BeanDefinitionBuilder.rootBeanDefinition(ConstantFactoryBean.class).addConstructorArgValue(value).getBeanDefinition();
    }
}

